<?php
namespace Mtc\Finder\ViewModel;

use Magento\Catalog\Api\Data\CategorySearchResultsInterface;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Request\Http;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Catalog\Api\CategoryListInterface;
use Magento\Catalog\Api\CategoryRepositoryInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\Api\SortOrderBuilder;

/**
 * Clan Shops view model
 */
class ClanShops implements ArgumentInterface
{
    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    /**
     * @var CategoryListInterface
     */
    private $categoryListRepository;

    /**
     * @var FilterBuilder
     */
    private $filterBuilder;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var Http
     */
    private $request;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var SortOrderBuilder
     */
    private $sortOrderBuilder;

    /**
     * @param CategoryListInterface $categoryListRepository
     * @param FilterBuilder $filterBuilder
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param CategoryRepositoryInterface $categoryRepository
     * @param Http $request
     * @param LoggerInterface $logger
     * @param SortOrderBuilder $sortOrderBuilder
     */
    public function __construct(
        CategoryListInterface $categoryListRepository,
        FilterBuilder $filterBuilder,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        CategoryRepositoryInterface $categoryRepository,
        Http $request,
        LoggerInterface $logger,
        SortOrderBuilder $sortOrderBuilder
    ) {
        $this->categoryListRepository = $categoryListRepository;
        $this->filterBuilder = $filterBuilder;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->categoryRepository = $categoryRepository;
        $this->request = $request;
        $this->logger = $logger;
        $this->sortOrderBuilder = $sortOrderBuilder;
    }

    /**
     * @return array|string[]
     */
    public function getLetters() {
        if ($this->request->getParam('search')) {
            return [$this->request->getParam('search')];
        }
        return ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
    }

    /**
     * @param $letter
     * @return CategorySearchResultsInterface|null
     */
    public function getCategoryList($letter) {
        $category = null;
        $categories = null;
        $categoryId = 8304;
        try{
            $category = $this->categoryRepository->get($categoryId);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
        if ($category) {
            $subCategories = $category->getChildrenCategories();
            $subCategoriesIds = [];
            foreach($subCategories as $subCategory) {
                if ($this->startsWith(strtolower(str_replace("Clan ", "",$subCategory->getName())), strtolower($letter))) {
                    $subCategoriesIds[] = $subCategory->getId();
                }
            }
            if ($subCategoriesIds) {
                $filters = [];
                $filters[] = $this->filterBuilder
                    ->setField('entity_id')
                    ->setConditionType('in')
                    ->setValue($subCategoriesIds)
                    ->create();
                $sortOrder = $this->sortOrderBuilder->setField('position')->setDirection('ASC')->create();
                $this->searchCriteriaBuilder->addFilters($filters)->setSortOrders([$sortOrder]);
                $searchCriteria = $this->searchCriteriaBuilder->create();
                return $this->categoryListRepository->getList($searchCriteria);
            }
        }
        return null;
    }

    /**
     * @param $string
     * @param $startString
     * @return bool
     */
    private function startsWith ($string, $startString): bool
    {
        $len = strlen($startString);
        return (substr($string, 0, $len) === $startString);
    }

    /**
     * @return mixed
     */
    public function getSearchParam() {
        return $this->request->getParam('search');
    }

    /**
     * @return mixed
     */
    public function getQueryParam() {
        return $this->request->getParam('query');
    }
}
