define([
    "jquery",
    "prototype",
    'Magento_Ui/js/modal/alert',
    "domReady!"
], function ($, prototype, alert) {
    'use strict';
    $.Tartan = function()
    {
        this.KC_value = '';
    };

    $.Tartan.prototype = {

        init: function(tileImg, shadowImg) {
            this.colorsList = [];
            this.tile = tileImg;
            this.shadow = shadowImg;
            this.t = {
                DEFAULT_PALLET: {K:"#000000", LP:"#9966FF", P:"#9933FF",
                    DP:"#990099", W:"#DDDDDD", DW:"#E1DFD0",
                    LY:"#FFFF66", Y:"#FFFF00", DY:"#FFCC00",
                    O:"#DDAA00", LT:"#FFCE24", T:"#BB5E00",
                    DT:"#663300", LN:"#999999", N:"#666666",
                    DN:"#333333", R:"#FD024E", LR:"#FF6262",
                    DR:"#CE0000", MR:"#A40004", LG:"#336633",
                    G:"#339900", DG:"#1B5300", OG:"#484E05",
                    BG:"#074B32", AB:"#229F7A", LB:"#88A8AA",
                    B:"#333399", DB:"#1E1E5B", RB:"#171366",
                    NB:"#171366"},
                DEFAULT_TAB: "O10NB2R4NB8R72NB44W8Y4",
                tab: null,
                pType: "P",
                pallet: null,
            };
            this.colorNames = {
                K:"Black", LP:"Violet", P:"Dark Violet",
                W:"White", DW:"Beige", Y:"Yellow",
                LT:"Tan", T:"Saddle Brown", DT:"Dark Brown",
                N:"Silver", DN:"Gray", R:"Red",
                DR:"Dark Red", LG:"Light Green",
                G:"Green", DG:"Dark Green", BG:"Dark Cyan",
                LB:"Light Blue", B:"Blue", NB:"Navy"
            }
            this.t.zoomFactor = 2;
            return this;
        },
        drawTartan: function(target, ptype, tabulation, pallet) {
            if (tabulation !== '') {
                let targetElem = '#'+target;
                let canvas = '';
                let tartanSetup = this;
                this.tDocument = document.getElementById(target);
                this.tContext = this.tDocument.getContext("2d");
                this.tilesAreLoaded = false;
                this.setup(tabulation,
                    pallet,
                    ptype);
                const c = $(targetElem);
                const container = $(c).parent().parent();
                $(window).resize( respondCanvas );
                function respondCanvas(){
                    c.attr('width', $(container).width() );
                    c.attr('height', $(container).height());
                    tartanSetup.setup(tabulation,pallet,ptype);
                }
                respondCanvas();
            }

        },
        setup: function(inputTab, inputPallet, inputPType) {
            this.tContext.clearRect ( 0 , 0 , this.tDocument.width, this.tDocument.height );
            if (inputPType === null)
            {
                this.t.pType = "P";
            }
            else
            {
                this.t.pType = inputPType;
            }
            if (inputPallet === null)
            {
                if (this.t.pallet == null)
                {
                    this.t.pallet = this.t.DEFAULT_PALLET;
                }
            }
            else
            {
                inputPallet = decodeURIComponent(inputPallet)
                this.t.pallet = this.buildPallet(inputPallet);
            }

            if (inputTab === null)
            {
                if (this.t.tab === null)
                {
                    this.t.tab = this.t.DEFAULT_TAB;
                }
            }
            else
            {
                this.t.tab = decodeURIComponent(inputTab)
            }
            this.buildThreadcount(this.t.tab)
            this.img = new Image();
            this.img.src = this.tile;
            this.img.crossOrigin = "anonymous";
            this.img2 = new Image();
            this.img2.src = this.shadow;
            this.img2.crossOrigin = "anonymous";
            self = this
            this.img2.addEventListener("load", function() {self.tileLoaded()}, false);
        },
        tileLoaded: function() {
            this.createWarp();
            this.createWeft();
        },
        buildPallet: function(inputPallet) {
            let s, i, returnPallet, pal;
            returnPallet = this.t.DEFAULT_PALLET
            const myArray = inputPallet.split(";");
            // Final item has ; so minus 1
            s = myArray.length-1;
            let code;
            let colour;
            for (i = 0; i < s; i++) {
                pal = myArray[i]
                if (pal !== "") {
                    if (/^[a-zA-Z0-9 =]+$/.test(pal)) {
                        code = this.getCode(pal)
                        if (this.isalpha(code.charCodeAt(0))) {
                            colour = this.getColour(pal)
                            returnPallet[code] = colour
                        }
                    }
                }
            }
            return returnPallet;
        },
        getReverse: function(arrTab) {
            // tab is, say, length 5. Each Tab contains one colour code and one number of treads
            // I want to create and return  tab(0),tab(1),tab(2),tab(3),tab(4),tab(3),tab(2),tab(1)
            // tab(5) is not repeated and tab(0) is not added to reverse

            const revArray = arrTab.slice(1, arrTab.length - 1);
            revArray.reverse();
            return arrTab.concat(revArray);

        },
        buildThreadcount: function(tab) {
            let tmpt;
            let tmpc;
            let c;
            let weft_offset = 0;
            let MarkerFound = false;
            let tabPart = [];
            this.t.warpStripe = [];
            this.t.weftStripe = [];
            let i = 0;
            this.t.threadCount = 0;

            // returns -1 if not found else zero based number of chars
            weft_offset = tab.indexOf(".");
            if (weft_offset !== -1){
                tabPart = tab.split(".");
                MarkerFound = true;
            }else {
                tabPart[0] = tab;
            }

            // make this into function ??
            // change tab to warpStripe and weftStripe
            // or t.stripe be changed into t.warpstripe and t.weftstripe
            while(i < tabPart[0].length)
            {
                tmpc = "";
                tmpt = "";
                if (this.isalnum(tabPart[0].charCodeAt(i)) !== true)
                {
                    if(tabPart[0].charAt(i) === '.') break;
                    i++;
                }

                if (this.isalpha(tabPart[0].charCodeAt(i)) )
                {
                    for(c = 0; c < 4 && this.isalpha(tabPart[0].charCodeAt(i));c++)
                    {
                        tmpc = tmpc.concat(tabPart[0].charAt(i++));
                    }
                }
                if (this.isnum(tabPart[0].charCodeAt(i) ))
                {
                    for(c = 0;c < 4 && this.isnum(tabPart[0].charCodeAt(i));c++)
                    {
                        tmpt = tmpt.concat(tabPart[0].charAt(i++));

                    }
                    this.t.threadCount = this.t.threadCount + (parseInt(tmpt)*this.t.zoomFactor)
                }
                // warp
                if (tmpc !== "" && tmpt !== "")
                {
                    this.t.warpStripe.push({ccode:tmpc, threads:parseInt(tmpt)});
                }

            }
            if(MarkerFound === true) {
                i = 0;
                while(i < tabPart[1].length)
                {
                    tmpc = "";
                    tmpt = "";
                    if (this.isalnum(tabPart[1].charCodeAt(i)) !== true)
                    {
                        if(tabPart[1].charAt(i) === '.') { // If . found at start just jump over
                            i++;
                        }

                    }

                    if (this.isalpha(tabPart[1].charCodeAt(i)) )
                    {
                        for(c = 0; c < 4 && this.isalpha(tabPart[1].charCodeAt(i));c++)
                        {
                            tmpc = tmpc.concat(tabPart[1].charAt(i++));
                        }
                    }
                    if (this.isnum(tabPart[1].charCodeAt(i) ))
                    {
                        for(c = 0;c < 4 && this.isnum(tabPart[1].charCodeAt(i));c++)
                        {
                            tmpt = tmpt.concat(tabPart[1].charAt(i++));

                        }
                        // no provision for recording threadcount of different weft
                        //t.threadCount = t.threadCount + (parseInt(tmpt)*t.zoomFactor)
                    }
                    // weft
                    if (tmpc !== "" && tmpt !== "")
                    {
                        this.t.weftStripe.push({ccode:tmpc, threads:parseInt(tmpt)});
                    }

                }
            } else {
                // duplicate warp if no Marker found
                this.t.weftStripe = this.t.warpStripe
            }
            // P means pivoting. R = Repeating
            // R type patterns do not require reversing procedure
            if (this.t.pType === "P")
            {
                // see explaination in getReverse()
                this.t.warpStripe = this.getReverse(this.t.warpStripe); // new func
                this.t.weftStripe = this.getReverse(this.t.weftStripe);
            }
        },
        createWarp: function() {

            const w = this.tDocument.width;
            const h = this.tDocument.height;

            let i;
            i = 0
            let xpos;
            xpos = 0;
            let s;
            s = this.t.warpStripe.length - 1;
            let rc;
            let rw;
            while (xpos < w)
            {
                rc = this.getColourByCode(this.t.warpStripe[i].ccode)
                rw = this.t.warpStripe[i].threads * this.t.zoomFactor;
                this.tContext.fillStyle=rc;
                this.tContext.fillRect(xpos, 0, rw, h);
                xpos += this.t.warpStripe[i].threads * this.t.zoomFactor;
                i++
                if (i > s) i = 0;
            }

        },
        createWeft: function() {

            let w;
            w = this.tDocument.width;
            let h;
            h = this.tDocument.height;

            let i = 0;
            // off-screen context
            const canvas = document.createElement("canvas");
            const twillContext = canvas.getContext("2d");
            canvas.width = w
            canvas.height = h

            // Create a pattern with this image, and set it to "repeat".
            // img = tile.png
            twillContext.fillStyle = twillContext.createPattern(this.img, 'repeat');
            twillContext.fillRect(0, 0, w, h);
            let s;
            s = this.t.weftStripe.length-1;
            let ypos;
            ypos = 0;
            let rc;
            let rh;
            while (ypos < h)
            {
                rc = this.getColourByCode(this.t.weftStripe[i].ccode)
                rh = this.t.weftStripe[i].threads * this.t.zoomFactor;
                rc = rc.substring(1,7)
                //this doesn't work
                //weftContext.setAttribute('crossOrigin', 'anonymous');
                // image.crossOrigin="anonymous";
                twillContext.crossOrigin="anonymous";
                const map = twillContext.getImageData(0, ypos, w, rh);
                const imdata = map.data;

                //var bigint = parseInt(rc, 16);
                const r = parseInt(rc.substring(0, 2), 16);
                const g = parseInt(rc.substring(2, 4), 16);
                const b = parseInt(rc.substring(4, 6), 16);
                let a = 0;

                for(var p = 0, len = imdata.length; p < len; p+=4) {

                    a = imdata[p+3];

                    imdata[p] = r;
                    imdata[p+1] = g;
                    imdata[p+2] = b;
                    imdata[p+3] = a;
                }
                twillContext.putImageData(map,0,ypos);

                ypos += this.t.weftStripe[i].threads * this.t.zoomFactor;
                i++
                if (i > s) i = 0;
            }


            // Create a pattern with this image, and set it to "repeat".
            // img2 = shaddow.png
            twillContext.fillStyle = twillContext.createPattern(this.img2, 'repeat');
            twillContext.fillRect(0, 0, w, h);
            // draw the twill pattern weft stripes over the warp
            this.tContext.drawImage(canvas, 0, 0);
        },
        getCode: function(mess) {
            let marray;
            marray = mess.split("=");
            return marray[0].toUpperCase();
        },
        getColour: function(mess) {
            let marray;
            marray = mess.split("=");
            return "#"+marray[1].substr(0, 6);
        },
        isnum: function(a) {
            return ( a > 47 && a < 58 );
        },
        isalnum: function(a) {
            return ( ( a > 47 && a < 58 ) ||( a > 64 && a < 90 ) || ( a > 96 && a < 122 ));
        },
        isalpha: function(a) {
            return (( a > 64 && a < 90 ) || ( a > 96 && a < 122 ));
        },
        setLine: function(imgData, i, l) {
            let b;
            for (b = 0; b < i; b += 4) {
                this.setPixel(imgData, b)
            }
        },
        setPixel: function(imgData, i, rValue, gValue, bValue, aValue) {
            imgData.data[i+0] = rValue;
            imgData.data[i+1] = gValue;
            imgData.data[i+2] = bValue;
            imgData.data[i+3] = aValue;
        },
        getColourByCode: function(colourCode) {
            let colour = "#666666";
            if (this.t.pallet[colourCode] != null)
            {
                colour = this.t.pallet[colourCode]
            }
            return colour;
        }
    }

    return new $.Tartan();
});
