<?php
namespace Mtc\Finder\Api;

use Mtc\Finder\Api\Data\TartanManagerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Declared inter
 * interface TartanManagerRepositoryInterface
 */
interface TartanManagerRepositoryInterface
{
    /**
     * Save tartan.
     *
     * @param TartanManagerInterface $event
     * @return mixed
     */
    public function save(TartanManagerInterface $event);

    /**
     * Retrieve tartan.
     *
     * @param $tartanId
     * @return mixed
     */
    public function getById($tartanId);

    /**
     * Retrieve list matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete tartan.
     *
     * @param TartanManagerInterface $tartan
     * @return mixed
     */
    public function delete(TartanManagerInterface $tartan);

    /**
     * Delete tartan by ID.
     *
     * @param $tartanId
     * @return mixed
     */
    public function deleteById($tartanId);
}
