<?php
namespace Mtc\Finder\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;
use Magento\Backend\App\Action\Context;

/**
 * Abstract class for actions
 * abstract AbstractController
 */
abstract class AbstractController extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }

    /**
     * this method is used to init breadcrumbs
     * @param $resultPage
     * @return mixed
     */
    public function _init($resultPage)
    {
        $resultPage->setActiveMenu('Mtc_Finder');
        $resultPage->addBreadcrumb(__('Tartan'), __('Manager'));
        $resultPage->addBreadcrumb(__('Manage Tartans'), __('Manage Tartans'));
        $resultPage->getConfig()->getTitle()->prepend(__('Manage Tartans'));

        return $resultPage;
    }

    /**
     * Check the permission to run it
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Mtc_Finder::manage_tartan');
    }
}
