<?php
namespace Mtc\Finder\Controller\Adminhtml\Manage;

use Mtc\Finder\Api\Data\TartanManagerInterface as TartanManagerInterfaceAlias;
use Mtc\Finder\Model\TartanManager;
use Magento\Backend\Model\View\Result\Redirect as RedirectAlias;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Magento\Backend\App\Action\Context;
use Mtc\Finder\Api\TartanManagerRepositoryInterface;
use Mtc\Finder\Model\TartanManagerFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;
use Mtc\Finder\Controller\Adminhtml\AbstractController;


/**
 * Action for save button
 *
 * Class Save
 */
class Save extends AbstractController
{
    /**
     * Constant
     */
    const DATE_FORMAT = 'Y-m-d';

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var TartanManagerFactory
     */
    private $eventManagerFactory;

    /**
     * @var TartanManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param DataPersistorInterface $dataPersistor
     * @param TartanManagerFactory $eventManagerFactory
     * @param TartanManagerRepositoryInterface $eventManagerRepository
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        DataPersistorInterface $dataPersistor,
        TartanManagerFactory $eventManagerFactory,
        TartanManagerRepositoryInterface $eventManagerRepository
    ) {
        $this->dataPersistor = $dataPersistor;
        $this->eventManagerFactory = $eventManagerFactory;
        $this->eventManagerRepository = $eventManagerRepository;
        parent::__construct($context, $resultPageFactory);
    }

    /**
     * Save action
     *
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        /** @var RedirectAlias $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        $model = $this->eventManagerFactory->create();
        if ($data) {
            $generalData = $data;
            $id = $generalData['entity_id'];
            /** @var TartanManager $model */
            if ($id) {
                try {
                    $model = $this->eventManagerRepository->getById($id);
                } catch (LocalizedException $e) {
                    $this->messageManager
                        ->addErrorMessage(__('This tartan no longer exists.'));
                    return $this->processResultRedirect($model, $resultRedirect, $data);
                }
            }
            if (isset($generalData['tartan_image'])) {
                $generalData['tartan_image'] = 'TartanManager/' .
                    $generalData['tartan_image'][0]['file'];
            }
            $model->setData($generalData);
            try {
                $model->setUpdatedAt('');
                $this->eventManagerRepository->save($model);
                $this->messageManager->addSuccessMessage(__('You saved the tartan.'));
                return $this->processResultRedirect($model, $resultRedirect, $data);
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage(
                    $e,
                    __('Something went wrong while saving the tartan.')
                );
            }
            $this->dataPersistor->set('mtc_tartan_manager', $data);
            return $this->processResultRedirect($model, $resultRedirect, $data);
        }
        return $this->processResultRedirect($model, $resultRedirect, $data);
    }

    /**
     * Process result redirect
     *
     * @param TartanManagerInterfaceAlias $model
     * @param RedirectAlias $resultRedirect
     * @param $model
     * @param $resultRedirect
     * @param $data
     * @return mixed
     */
    private function processResultRedirect($model, $resultRedirect, $data)
    {
        $this->dataPersistor->clear('mtc_tartan_manager');
        if ($this->getRequest()->getParam('back', false) === 'continue') {
            return $resultRedirect->setPath('*/*/edit', ['entity_id' => $model->getId(), '_current' => true]);
        }
        return $resultRedirect->setPath('*/*/index');
    }
}
