<?php
namespace Mtc\Finder\Model;

use Magento\Framework\Exception\LocalizedException;
use Mtc\Finder\Api\Data\TartanManagerInterface;
use Mtc\Finder\Model\ResourceModel\TartanManager as TartanManagerResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractExtensibleModel;

/**
 * This model class is used for the Curd operation of Tartans
 *
 * Class TartanManager
 */
class TartanManager extends AbstractExtensibleModel implements TartanManagerInterface, IdentityInterface
{
    /**
     * @var PAGE_CACHE
     */
    const CACHE_TAG = 'mtc_tartan_manager';

    /**
     * @var PAGE_CACHE|string
     */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Constructor to initialize ResourceModel
     */
    public function _construct()
    {
        $this->_init(TartanManagerResourceModel::class);
    }

    /**
     * Return unique ID(s) for each object in system
     *
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId(), self::CACHE_TAG . '_' . $this->getId()];
    }
    
    /**
     * @param string $tartanId
     * @return $this
     */
    public function setTartanId($tartanId)
    {
        return $this->setData(self::TARTAN_ID, $tartanId);
    }

    /**
     * @return string
     */
    public function getTartanId()
    {
        return $this->getData(self::TARTAN_ID);
    }

    /**
     * @param int $categoryId
     * @return $this
     */
    public function setCategoryId($categoryId)
    {
        return $this->setData(self::CATEGORY_ID, $categoryId);
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {
        return $this->getData(self::CATEGORY_ID);
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        return $this->setData(self::NAME, $name);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->getData(self::NAME);
    }

    /**
     * @param string $tartanImage
     * @return $this
     */
    public function setTartanImage($tartanImage)
    {
        return $this->setData(self::TARTAN_IMAGE, $tartanImage);
    }

    /**
     * @return string
     */
    public function getTartanImage()
    {
        return $this->getData(self::TARTAN_IMAGE);
    }

    /**
     * It will return the tartan image URL
     *
     * @return string
     */
    public function getTartanImageURL()
    {
        if ($this->getTartanImage() == '') {
            return '';
        }
        return $this->getMediaUrl($this->getTartanImage());
    }

    /**
     * @param string $canBuy
     * @return $this
     */
    public function setCanBuy($canBuy)
    {
        return $this->setData(self::CAN_BUY, $canBuy);
    }

    /**
     * @return string
     */
    public function getCanBuy()
    {
        return $this->getData(self::CAN_BUY);
    }


    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @param string $airtableCreatedAt
     * @return $this
     */
    public function setAirtableCreatedAt($airtableCreatedAt)
    {
        return $this->setData(self::AIRTABLE_CREATED_AT, $airtableCreatedAt);
    }

    /**
     * @return string
     */
    public function getAirtableCreatedAt()
    {
        return $this->getData(self::AIRTABLE_CREATED_AT);
    }

    /**
     * @param string $airtableModifiedAt
     * @return $this
     */
    public function setAirtableModifiedAt($airtableModifiedAt)
    {
        return $this->setData(self::AIRTABLE_MODIFIED_AT);
    }

    /**
     * @return string
     */
    public function getAirtableModifiedAt()
    {
        return $this->getData(self::AIRTABLE_MODIFIED_AT);
    }

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT);
    }

    /**
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @param $refPic
     * @return TartanManager
     */
    public function setRefPic($refPic)
    {
        return $this->setData(self::REF_PIC, $refPic);
    }

    /**
     * @return mixed|string|null
     */
    public function getRefPic()
    {
        return $this->getData(self::REF_PIC);
    }

    /**
     * @param $family
     * @return TartanManager
     */
    public function setFamily($family)
    {
        return $this->setData(self::FAMILY, $family);
    }

    /**
     * @return mixed|string|null
     */
    public function getFamily()
    {
        return $this->getData(self::FAMILY);
    }

    /**
     * @param $duplicateLists
     * @return TartanManager
     */
    public function setDuplicateLists($duplicateLists)
    {
        return $this->setData(self::DUPLICATE_LIST, $duplicateLists);
    }

    /**
     * @return mixed|string|null
     */
    public function getDuplicateLists()
    {
        return $this->getData(self::DUPLICATE_LIST);
    }
    
    /**
     * @param $partner
     * @return TartanManager
     */
    public function setPartner($partner)
    {
        return $this->setData(self::PARTNER, $partner);
    }

    /**
     * @return mixed|string|null
     */
    public function getPartner()
    {
        return $this->getData(self::PARTNER);
    }

    /**
     * @param $colours
     * @return TartanManager
     */
    public function setColours($colours)
    {
        return $this->setData(self::COLOURS, $colours);
    }

    /**
     * @return mixed|string|null
     */
    public function getColours()
    {
        return $this->getData(self::COLOURS);
    }
    
    /**
     * @param $sortOrder
     * @return TartanManager
     */
    public function setSortOrder($sortOrder)
    {
        return $this->setData(self::SORT_ORDER, $sortOrder);
    }

    /**
     * @return mixed|string|null
     */
    public function getSortOrder()
    {
        return $this->getData(self::SORT_ORDER);
    }

    /**
     * @param $classification
     * @return TartanManager
     */
    public function setClassification($classification)
    {
        return $this->setData(self::CLASSIFICATION, $classification);
    }

    /**
     * @return mixed|string|null
     */
    public function getClassification()
    {
        return $this->getData(self::CLASSIFICATION);
    }

    /**
     * @param int $entityId
     * @return $this
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param $colourId
     * @return TartanManager
     */
    public function setColourId($colourId)
    {
        return $this->setData(self::COLOUR_ID, $colourId);
    }

    /**
     * @return mixed|string|null
     */
    public function getColourId()
    {
        return $this->getData(self::COLOUR_ID);
    }

    /**
     * @param $supplier
     * @return TartanManager
     */
    public function setSupplier($supplier)
    {
        return $this->setData(self::SUPPLIER, $supplier);
    }

    /**
     * @return mixed|string|null
     */
    public function getSupplier()
    {
        return $this->getData(self::SUPPLIER);
    }

    /**
     * @param $weight
     * @return TartanManager
     */
    public function setWeight($weight)
    {
        return $this->setData(self::WEIGHT, $weight);
    }

    /**
     * @return mixed|string|null
     */
    public function getWeight()
    {
        return $this->getData(self::WEIGHT);
    }

    /**
     * @param $collection
     * @return TartanManager
     */
    public function setCollection($collection)
    {
        return $this->setData(self::COLLECTION, $collection);
    }

    /**
     * @return mixed|string|null
     */
    public function getCollection()
    {
        return $this->getData(self::COLLECTION);
    }

    /**
     * @param $manRef
     * @return TartanManager
     */
    public function setManRef($manRef)
    {
        return $this->setData(self::MAN_REF, $manRef);
    }

    /**
     * @return mixed|string|null
     */
    public function getManRef()
    {
        return $this->getData(self::MAN_REF);
    }

    /**
     * @param $hotProductCode
     * @return TartanManager
     */
    public function setHotProductCode($hotProductCode)
    {
        return $this->setData(self::HOT_PRODUCT_CODE, $hotProductCode);
    }

    /**
     * @return mixed|string|null
     */
    public function getHotProductCode()
    {
        return $this->getData(self::HOT_PRODUCT_CODE);
    }

    /**
     * @param $notes
     * @return TartanManager
     */
    public function setNotes($notes)
    {
        return $this->setData(self::NOTES, $notes);
    }

    /**
     * @return mixed|string|null
     */
    public function getNotes()
    {
        return $this->getData(self::NOTES);
    }

}
