<?php
namespace Mtc\Finder\Plugin;

use Magento\Swatches\Block\Product\Renderer\Configurable;
use Magento\Framework\App\Request\Http;
use Magento\Catalog\Api\ProductAttributeRepositoryInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Mtc\Finder\Api\TartanManagerRepositoryInterface;

class UpdateCacheKey
{
    /**
     * @var Http
     */
    private $request;

    /**
     * @var ProductAttributeRepositoryInterface
     */
    private $productAttributeRepository;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var TartanManagerRepositoryInterface
     */
    private $tartanRepository;

    /**
     * @param Http $request
     * @param ProductAttributeRepositoryInterface $productAttributeRepository
     * @param LoggerInterface $logger
     * @param SerializerInterface $serializer
     * @param TartanManagerRepositoryInterface $tartanRepository
     */
    public function __construct (
        Http $request,
        ProductAttributeRepositoryInterface $productAttributeRepository,
        LoggerInterface $logger,
        SerializerInterface $serializer,
        TartanManagerRepositoryInterface $tartanRepository
    ) {
        $this->request = $request;
        $this->productAttributeRepository = $productAttributeRepository;
        $this->logger = $logger;
        $this->serializer = $serializer;
        $this->tartanRepository = $tartanRepository;
    }

    /**
     * @param Configurable $subject
     * @param $result
     * @return mixed|string
     */
    public function afterGetCacheKey(Configurable $subject, $result)
    {
        if ($this->request->getParam('tartan_code')) {
            return $result . '-tartan-' . $this->request->getParam('tartan_code');
        }
        if ($this->request->getParam('clan')) {
            return $result . '-clan-' . $this->request->getParam('clan');
        }
        return $result;
    }

    /**
     * @param Configurable $subject
     * @param $result
     * @return mixed
     */
    public function afterGetJsonSwatchConfig(Configurable $subject, $result) {
        $tartan = null;
        try {
            $tartan = $this->productAttributeRepository->get('tartan');
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage());
        }
        if ($tartan) {
            $result = $this->serializer->unserialize($result);
            $tartanAttributeId = $tartan->getAttributeId();
            if (isset($result[$tartanAttributeId])) {
                $options = $result[$tartanAttributeId];
                if (is_array($options)) {
                    foreach ($options as $option => $optionData) {
                        $tartanAdminValue = $tartan->setStoreId(0)->getSource()->getOptionText($option);
                        $tartanId = substr($tartanAdminValue, 0, strpos($tartanAdminValue, '-'));
                        if ($tartanId) {
                            $tartanObj = null;
                            try {
                                $tartanObj = $this->tartanRepository->getById($tartanId);
                            } catch (\Exception $e) {
                                $this->logger->error($e->getMessage());
                            }
                            if ($tartanObj) {
                                $colour = $tartanObj->getColourId();
                                $result[$tartanAttributeId][$option]['colour_id'] = $colour;
                            }
                        }
                    }
                }
            }
            $result = $this->serializer->serialize($result);
        }
        return $result;
    }
}
