require([
    'jquery'
], function ($) {
    $(document).ready(function () {
        $(document).on("click", '.tartan-colourway', function() {
            let colourwayhtml = '';
            let currentProductId = $(this).data('product-id');
            let colourId = $(this).data('colour-name');
            let tartanName = $(this).data('tartan-label');
            let imgElem;
            let tartanThumb = $(this).data('tartan-image');
            let htmlStr = "";
            let optionId = $(this).data('option-id');
            let tartanId = $(this).data('tartan-id');
            let tartanAttributeId = $(this).data('tartan-id');
            let elemId = $(this).data('id');
            $(document).find('#swatch-opt-'+currentProductId+' div[id*="option-label-tartan"]').each(function () {
                let tartanLabel = $(this).data('option-label');
                let colourName = $(this).data('colour-id');
                let tartanNewName = tartanLabel.replace(colourName, "").trim();
                let tartanImage;
                if (colourName && tartanNewName && tartanNewName === tartanName &&  colourName !== colourId) {
                    if (typeof $(this).data('option-tooltip-value') !== 'undefined')
                    {
                        if ($(this).data('option-tooltip-value')) {
                            tartanImage = $(this).data('option-tooltip-value');
                            tartanImage = tartanImage.substring(0, tartanImage.indexOf('?'));
                            colourwayhtml += '<li class="product-item">' +
                                '<div class="product-item-info">' +
                                '<a href="#product-options-wrapper" data-id="'+$(this).data('id')+'" data-tartan-id="'+tartanAttributeId+'" data-option-id="'+$(this).data('option-id')+'" data-tartan-label="'+tartanNewName+'" data-tartan-image="'+tartanImage+'" data-colour-name="'+colourName+'" data-product-id="'+currentProductId+'" class="product-item-photo tartan-colourway">' +
                                '<img src="'+tartanImage+'">' +
                                '</a>' +
                                '<div class="product-item-details">' +
                                '<strong class="product-item-name">' +tartanLabel+
                                '</strong>' +
                                '</div>' +
                                '</div>' +
                                '</li>';
                        }
                    }
                }
            });
            if (colourwayhtml) {
                $('#colourway-block .widget-product-grid').html(colourwayhtml);
                $('#colourway-block').show();
                imgElem = '<img src="'+tartanThumb+'">';
                htmlStr = imgElem + '<span class="tartan-title">'+tartanName+' '+colourId+'</span>';
                $('#selected-tartan-'+currentProductId).html(htmlStr);
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).parent().parent().find('.selected').removeClass('selected');
                $(document).find('.swatch-attribute-selected-option').text(tartanName+' '+colourId);
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).parent().parent().parent().find('.swatch-input').val(optionId);
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).parent().parent().parent().find('.swatch-input').attr('tartan');
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).addClass('selected');
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).parent().parent().attr('aria-activedescendant', elemId)
                    .find('.swatch-option').attr('aria-checked', false);
                $(document).find('#option-label-tartan-'+tartanId+'-item-'+optionId).attr('aria-checked', true);
            }
        });
    });
});
