define([
    'jquery',
    'underscore',
    'jquery/ui',
    'jquery/jquery.parsequery',
    'mage/translate'
], function ($, _) {
    'use strict';
    return function (widget) {

        $.widget('mage.SwatchRenderer', widget, {

            /**
             * Input for submit form.
             * This control shouldn't have "type=hidden", "display: none" for validation work :(
             *
             * @param {Object} config
             * @private
             */
            _RenderFormInput: function (config) {
                let msgTxt = $.mage.__("Please select tartan.");
                if (this.options.fieldDisabled) {
                    return '<input class="' + this.options.classes.attributeInput + ' super-attribute-select" ' +
                        'name="super_attribute[' + this.options.jsonConfig.productId + '][' + config.id + ']" ' +
                        'type="text" ' +
                        'value="" ' +
                        'data-selector="super_attribute[' + config.id + ']" ' +
                        'data-validate="{required: true}" ' +
                        'aria-required="true" ' +
                        'aria-invalid="false" ' +
                        'data-errors-message-box="#tartan-errors-'+this.options.jsonConfig.productId+'" ' +
                        'data-msg-required="' + msgTxt + '" ' +
                        'disabled="disabled">';
                } else {
                    return '<input class="' + this.options.classes.attributeInput + ' super-attribute-select" ' +
                        'name="super_attribute[' + this.options.jsonConfig.productId + '][' + config.id + ']" ' +
                        'type="text" ' +
                        'value="" ' +
                        'data-selector="super_attribute[' + config.id + ']" ' +
                        'data-validate="{required: true}" ' +
                        'aria-required="true" ' +
                        'aria-invalid="false" ' +
                        'data-errors-message-box="#tartan-errors-'+this.options.jsonConfig.productId+'" ' +
                        'data-msg-required="' + msgTxt + '">';
                }
            },
            /**
             * Render swatch options by part of config
             *
             * @param {Object} config
             * @param {String} controlId
             * @returns {String}
             * @private
             */
            _RenderSwatchOptions: function (config, controlId) {
                var optionConfig = this.options.jsonSwatchConfig[config.id],
                    optionClass = this.options.classes.optionClass,
                    sizeConfig = this.options.jsonSwatchImageSizeConfig,
                    moreLimit = parseInt(this.options.numberToShow, 10),
                    moreClass = this.options.classes.moreButton,
                    moreText = this.options.moreButtonText,
                    countAttributes = 0,
                    html = '';

                if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {
                    return '';
                }

                $.each(config.options, function (index) {
                    var id,
                        type,
                        value,
                        thumb,
                        label,
                        width,
                        height,
                        attr,
                        swatchImageWidth,
                        swatchImageHeight,
                        colour_id;

                    if (!optionConfig.hasOwnProperty(this.id)) {
                        return '';
                    }

                    // Add more button
                    if (moreLimit === countAttributes++) {
                        html += '<a href="#" class="' + moreClass + '"><span>' + moreText + '</span></a>';
                    }

                    id = this.id;
                    type = parseInt(optionConfig[id].type, 10);
                    value = optionConfig[id].hasOwnProperty('value') ?
                        $('<i></i>').text(optionConfig[id].value).html() : '';
                    thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';
                    width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;
                    height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;
                    label = this.label ? $('<i></i>').text(this.label).html() : '';
                    colour_id = optionConfig[id].hasOwnProperty('colour_id') ?
                        optionConfig[id].colour_id : '';
                    attr =
                        ' id="' + controlId + '-item-' + id + '"' +
                        ' index="' + index + '"' +
                        ' aria-checked="false"' +
                        ' aria-describedby="' + controlId + '"' +
                        ' tabindex="0"' +
                        ' data-option-type="' + type + '"' +
                        ' data-option-id="' + id + '"' +
                        ' data-option-label="' + label + '"' +
                        ' aria-label="' + label + '"' +
                        ' role="option"' +
                        ' data-thumb-width="' + width + '"' +
                        ' data-thumb-height="' + height + '"' +
                        ' data-colour-id="' + colour_id + '"';

                    attr += thumb !== '' ? ' data-option-tooltip-thumb="' + thumb + '"' : '';
                    attr += value !== '' ? ' data-option-tooltip-value="' + value + '"' : '';

                    swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;
                    swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;

                    if (!this.hasOwnProperty('products') || this.products.length <= 0) {
                        attr += ' data-option-empty="true"';
                    }

                    if (type === 0) {
                        // Text
                        html += '<div class="' + optionClass + ' text" ' + attr + '>' + (value ? value : label) +
                            '</div>';
                    } else if (type === 1) {
                        // Color
                        html += '<div class="' + optionClass + ' color" ' + attr +
                            ' style="background: ' + value +
                            ' no-repeat center; background-size: initial;">' + '' +
                            '</div>';
                    } else if (type === 2) {
                        // Image
                        html += '<div class="option-paragraph"><div class="' + optionClass + ' image" ' + attr +
                            ' style="background: url(' + value + ') no-repeat center; background-size: initial;width:' +
                            swatchImageWidth + 'px; height:' + swatchImageHeight + 'px">' + '' +
                            '</div><div class="swatchlabel-paragraph">'+label+'</div></div>';
                    } else if (type === 3) {
                        // Clear
                        html += '<div class="' + optionClass + '" ' + attr + '></div>';
                    } else {
                        // Default
                        html += '<div class="' + optionClass + '" ' + attr + '>' + label + '</div>';
                    }
                });

                return html;
            },
            /**
             * Event for swatch options
             *
             * @param {Object} $this
             * @param {Object} $widget
             * @private
             */
            _OnClick: function ($this, $widget) {
                $widget._super($this, $widget);
                let tartanOptionId;
                let tartanAttributeId;
                let tartanAttributeCode;
                let tartanThumb;
                let imgElem;
                let tartanTitle;
                let htmlStr = "";
                let colourId;
                let tartanLabel;
                let colourName;
                let tartanNewName;
                let colourwayhtml;
                let tartanImage;
                tartanAttributeId = $this.parents('.' + $widget.options.classes.attributeClass).data('attribute-id');
                tartanOptionId = $this.data('option-id');
                tartanThumb = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['thumb'];
                tartanTitle = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['label'];
                imgElem = '<img src="'+tartanThumb+'">';
                htmlStr = imgElem + '<span class="tartan-title">'+tartanTitle+'</span>';
                $('#selected-tartan-'+this.options.jsonConfig.productId).html(htmlStr);
                if ($( "#colourway-block" ).length) {
                    $('#colourway-block .widget-product-grid').html('');
                    $('#colourway-block').hide();
                    if (typeof this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['colour_id'] !== 'undefined') {
                        if (this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['colour_id']) {
                            colourId = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['colour_id'];
                            let tartanName = tartanTitle.replace(colourId, "").trim();
                            let productId = $widget.options.jsonConfig.productId;
                            colourwayhtml = '';
                            $(document).find('#swatch-opt-'+productId+' div[id*="option-label-tartan"]').each(function () {
                                tartanLabel = $(this).data('option-label');
                                colourName = $(this).data('colour-id');
                                tartanNewName = tartanLabel.replace(colourName, "").trim();
                                if (colourName && tartanNewName && tartanNewName === tartanName &&  colourName !== colourId) {
                                    if (typeof $(this).data('option-tooltip-value') !== 'undefined')
                                    {
                                        if ($(this).data('option-tooltip-value')) {
                                            tartanImage = $(this).data('option-tooltip-value');
                                            tartanImage = tartanImage.substring(0, tartanImage.indexOf('?'));
                                            colourwayhtml += '<li class="product-item">' +
                                                '<div class="product-item-info">' +
                                                '<a href="#product-options-wrapper" data-id="'+$(this).attr('id')+'" data-tartan-id="'+tartanAttributeId+'" data-option-id="'+$(this).data('option-id')+'" data-tartan-label="'+tartanName+'" data-tartan-image="'+tartanImage+'" data-colour-name="'+colourName+'" data-product-id="'+$widget.options.jsonConfig.productId+'" class="product-item-photo tartan-colourway">' +
                                                '<img src="'+tartanImage+'">' +
                                                '</a>' +
                                                '<div class="product-item-details">' +
                                                '<strong class="product-item-name">' +tartanLabel+
                                                '</strong>' +
                                                '</div>' +
                                                '</div>' +
                                                '</li>';
                                        }
                                    }
                                }
                            });
                            if (colourwayhtml) {
                                $('#colourway-block .widget-product-grid').html(colourwayhtml);
                                $('#colourway-block').show();
                            }
                        }
                    }
                }
            }
        });

        return $.mage.SwatchRenderer;
    }
});
