<?php
namespace Mtc\Finder\Controller\Adminhtml\Manage;

use Mtc\Finder\Model\ResourceModel\TartanManager\CollectionFactory;
use Magento\Backend\App\Action;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Ui\Component\MassAction\Filter;
use Mtc\Finder\Api\TartanManagerRepositoryInterface;

class MassDelete extends Action
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var Filter
     */
    private $filter;

    /**
     * @var TartanManagerRepositoryInterface
     */
    private $tartanManagerRepository;

    public function __construct(
        Action\Context $context,
        CollectionFactory $collectionFactory,
        Filter $filter,
        TartanManagerRepositoryInterface $tartanManagerRepository
    ) {
        parent::__construct($context);
        $this->collectionFactory = $collectionFactory;
        $this->filter = $filter;
        $this->tartanManagerRepository = $tartanManagerRepository;
    }

    public function execute()
    {
        try {
            $this->filter->applySelectionOnTargetProvider();
            $collection = $this->filter->getCollection($this->collectionFactory->create());
            $deleted = $failed = 0;

            foreach ($collection->getItems() as $tartanlist) {
                try {
                    $this->tartanManagerRepository->delete($tartanlist);
                    $deleted++;
                } catch (CouldNotDeleteException $e) {
                    $this->messageManager->addErrorMessage(__($e->getMessage()));
                    $failed++;
                }
            }

            if ($deleted != 0) {
                $this->messageManager->addSuccessMessage(
                    __('%1 tartan(s) has been successfully deleted', $deleted)
                );
            }
            if ($failed != 0) {
                $this->messageManager->addErrorMessage(
                    __('%1 tartan(s) has been failed to delete', $failed)
                );
            }
        } catch (\Exception $e) {
            $this->messageManager->addExceptionMessage(
                $e,
                __('Something went wrong while deleting tartan(s). Please review the error log.')
            );
        }

        return $this->resultRedirectFactory->create()->setPath('tartans/*/index');
    }
}
