<?php
namespace Mtc\Finder\Plugin;

use Magento\Catalog\Block\Navigation;
use Magento\Framework\App\Request\Http;

class AddTartan
{

    private $request;

    public function __construct(
        Http $request
    ) {
        $this->request = $request;
    }

    public function afterGetCategoryUrl(Navigation $subject, $result)
    {
        if ($this->request->getParam('tartan_code')) {
            $params = ['tartan_code' => $this->request->getParam('tartan_code')];
            $urlParams = [];
            foreach ($params as $name=>$value){
                $urlParams[] = $name.'='.urlencode($value);
            }
            $urlParams = implode('&', $urlParams);
            if ($urlParams){
                $glue = '?';
                if (str_contains($result, $glue)){
                    $glue = '&';
                }
                $result .= $glue.$urlParams;
            }
        }
        if ($this->request->getParam('clan')) {
            $params = ['clan' => $this->request->getParam('clan')];
            $urlParams = [];
            foreach ($params as $name=>$value){
                $urlParams[] = $name.'='.urlencode($value);
            }
            $urlParams = implode('&', $urlParams);
            if ($urlParams){
                $glue = '?';
                if (str_contains($result, $glue)){
                    $glue = '&';
                }
                $result .= $glue.$urlParams;
            }
        }
        return $result;
    }
}
