<?php
namespace Mtc\Finder\Plugin;

use Magento\ConfigurableProduct\Block\Product\View\Type\Configurable;
use Magento\Framework\App\Request\Http;
use Mtc\Clans\Model\ClanManagerFactory as ClanManagerModel;
use Psr\Log\LoggerInterface;

class AddTartanClanFilter
{

    /**
     * @var Http
     */
    private $request;
    
    /**
     * @var ClanManagerModel
     */
    private $clanManager;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Http $request
     * @param ClanManagerModel $clanManager
     * @param LoggerInterface $logger
     */
    public function __construct(
        Http $request,
        ClanManagerModel $clanManager,
        LoggerInterface $logger
    ) {
        $this->request = $request;
        $this->clanManager = $clanManager;
        $this->logger = $logger;
    }

    /**
     * @param Configurable $subject
     * @param $result
     * @return mixed
     */
    public function afterGetAllowProducts(Configurable $subject, $result)
    {
        $products = [];
        if ($this->request->getParam('tartan_code')) {
            foreach ($result as $product) {
                $attr = $product->getResource()->getAttribute('tartan');
                $tartanId = '';
                if ($attr->usesSource()) {
                    $tartanId = $attr->setStoreId(0)->getSource()->getOptionText($product->getTartan());
                    $tartanId = substr($tartanId, 0, strpos($tartanId, '-'));
                }
                if ($tartanId && $tartanId == $this->request->getParam('tartan_code')) {
                    $products[] = $product;
                }
            }
        }
        if ($this->request->getParam('clan')) {
            $clanId = $this->request->getParam('clan');
            $model = $this->clanManager->create();
            $tartans = $model->getTartans($clanId);
            $clanTartanIds = [];
            if ($tartans) {
                foreach ($tartans as $tartan) {
                    $clanTartanIds[] = $tartan['tartan_entity_id'];
                }
            }
            if (!empty($clanTartanIds)) {
                foreach ($result as $product) {
                    $attr = $product->getResource()->getAttribute('tartan');
                    $tartanId = '';
                    if ($attr->usesSource()) {
                        $tartanId = $attr->setStoreId(0)->getSource()->getOptionText($product->getTartan());
                        $tartanId = substr($tartanId, 0, strpos($tartanId, '-'));
                    }
                    if ($tartanId && in_array($tartanId, $clanTartanIds)) {
                        $products[] = $product;
                    }
                }
            }
        }
        if ($products) {
            $subject->setAllowProducts($products);
            return $subject->getData('allow_products');
        }   
        return $result;
    }
}
