<?php
namespace Mtc\Finder\Model\Config\Source;

use Magento\Framework\Exception\LocalizedException;
use Mtc\Finder\Model\AbstractArray;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;

class Categories extends AbstractArray
{

    /**
     * @var CollectionFactory
     */
    private $categoryCollection;

    /**
     * @param CollectionFactory $categoryCollection
     */
    public function __construct(
        CollectionFactory $categoryCollection
    ) {
        $this->categoryCollection = $categoryCollection;
    }

    /**
     * @return array
     * @throws LocalizedException
     */
    public function toArray(): array
    {
        $categories = [];
        $collection = $this->categoryCollection->create();
        $collection->addAttributeToSelect('name')
            ->addAttributeToSelect('url_key')
            ->addAttributeToSelect('url_path');
        $collection->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
        /* @var $collection \Magento\Catalog\Model\ResourceModel\Category\Collection */
        foreach ($collection as $category) {
            $structure = explode('/', $category->getPath());
            $pathSize = count($structure);
            if ($pathSize > 1) {
                $path = [];
                for ($i = 1; $i < $pathSize; $i++) {
                    $name = $collection->getItemById((int)$structure[$i])->getName();
                    $path[] = str_replace('/', '\\' . '/', $name);
                }
                /** @var string $index */
                $index = implode('/', $path);
                $categories[$category->getId()] = $index;
            }
        }
        return $categories;
    }
}
