<?php
namespace Mtc\Finder\Setup\Patch\Data;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Attribute\Repository;
use Magento\Catalog\Model\Product\Media\Config;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\App\State;
use Magento\Framework\File\Csv;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Swatches\Helper\Media;
use Magento\Framework\App\Filesystem\DirectoryList;

class AddTartanSwatch implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    const PRODUCT_GROUP = 'Product Details';

    /** @var Filesystem  */
    private $filesystem;

    /** @var State */
    private $state;

    /** @var Config */
    private $productMediaConfig;

    /** @var File */
    private $driverFile;

    /** @var Repository $attributeRepository */
    private $attributeRepository;

    /** @var Media */
    private $swatchHelper;

    /**
     * @var DirectoryList
     */
    private $directoryList;

    /**
     * @var File
     */
    private $file;

    /**
     * @var Csv
     */
    private $csv;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     * @param State $state
     * @param Filesystem $filesystem
     * @param Config $productMediaConfig
     * @param File $driverFile
     * @param Media $swatchHelper
     * @param Repository $attributeRepository
     * @param DirectoryList $directoryList
     * @param File $file
     * @param Csv $csv
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory,
        State $state,
        Filesystem $filesystem,
        Config $productMediaConfig,
        File $driverFile,
        Media $swatchHelper,
        Repository $attributeRepository,
        DirectoryList $directoryList,
        File $file,
        Csv $csv
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->state = $state;
        $this->filesystem = $filesystem;
        $this->productMediaConfig = $productMediaConfig;
        $this->driverFile = $driverFile;
        $this->attributeRepository = $attributeRepository;
        $this->swatchHelper = $swatchHelper;
        $this->directoryList = $directoryList;
        $this->file = $file;
        $this->csv = $csv;
    }

    /**
     * @return array|string[]
     */
    public static function getDependencies()
    {
        return [];
    }

    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        if (!$eavSetup->getAttribute(Product::ENTITY, 'tartan')) {
            $tartans = $this->directoryList->getPath(DirectoryList::MEDIA).'/tartanswatches.csv';
            if ($this->file->isExists($tartans)) {
                //set delimiter, for tab pass "\t"
                $this->csv->setDelimiter(",");
                //get data as an array
                $tartansData = $this->csv->getData($tartans);
                $images = [];
                $tartanNames = [];
                $flag = 0;
                foreach ($tartansData as $index => $value) {
                    if ($flag != 0) {
                        $images['option_'.$tartansData[$index][0]] = $tartansData[$index][2];

                        $name=$tartansData[$index][1];
                        $whatIWant = substr($name, strpos($name, "-") + 1);

                        $tartanNames['option_'.$tartansData[$index][0]][0] = str_replace(',', '', $name);
                        $tartanNames['option_'.$tartansData[$index][0]][2] = $whatIWant;

                    }
                    $flag = $flag+1;
                }
            }

            $attributesData = [
                'tartan' => [
                    'type' => 'int',
                    'label' => 'Tartan',
                    'input' => 'select',
                    'backend' => 'Magento\Eav\Model\Entity\Attribute\Backend\ArrayBackend',
                    'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Table',
                    'required' => false,
                    'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                    'group' => self::PRODUCT_GROUP,
                    'used_in_product_listing' => true,
                    'visible_on_front' => true,
                    'user_defined' => true,
                    'filterable' => 2,
                    'filterable_in_search' => true,
                    'used_for_promo_rules' => true,
                    'is_html_allowed_on_front' => true,
                    'used_for_sort_by' => true,
                ],
            ];
            $attributesOptionsData = [
                'tartan' => [
                    \Magento\Swatches\Model\Swatch::SWATCH_INPUT_TYPE_KEY => \Magento\Swatches\Model\Swatch::SWATCH_INPUT_TYPE_VISUAL,
                    'optionvisual' => [
                        'value'     => $tartanNames,
                    ],
                    'swatchvisual' => [
                        'value'     => $images,
                    ],
                ]
            ];

            $this->addProductAttributes($attributesData, $attributesOptionsData);
        }

    }

    private function addProductAttributes($attributesData, $attributesOptionsData)
    {
        try {
            // Make sure we don't get error "Area code is not set".
            $this->state->setAreaCode('admin');
        } catch (\Exception $ignored) {}

        try {
            $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
            $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY, 'tartan');
            // Add attributes.
            foreach ($attributesData as $code => $attributeData) {
                $eavSetup->addAttribute(\Magento\Catalog\Model\Product::ENTITY, $code, $attributeData);
            }
            // Add order if it doesn't exist. This is an important step to make sure everything will be created correctly.
            foreach ($attributesOptionsData as &$attributeOptionsData) {
                $order = 0;
                $swatchVisualFiles = $attributeOptionsData['optionvisual']['value'] ?? [];
                foreach ($swatchVisualFiles as $index => $swatchVisualFile) {
                    if (!isset($attributeOptionsData['optionvisual']['order'][$index])) {
                        $attributeOptionsData['optionvisual']['order'][$index] = ++$order;
                    }
                }
            }
            // Prepare visual swatches files.
            $mediaDirectory = $this->filesystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA);
            $tmpMediaPath = $this->productMediaConfig->getBaseTmpMediaPath();
            $fullTmpMediaPath = $mediaDirectory->getAbsolutePath($tmpMediaPath);

            $this->driverFile->createDirectory($fullTmpMediaPath.'/tartans_images');
            foreach ($attributesOptionsData as &$attributeOptionsData) {
                $swatchVisualFiles = $attributeOptionsData['swatchvisual']['value'] ?? [];

                foreach ($swatchVisualFiles as $index => $swatchVisualFile) {

                    if ($this->file->isExists($this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . $swatchVisualFile)) {
                        $this->driverFile->copy(
                            $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath() . $swatchVisualFile,
                            $fullTmpMediaPath . DIRECTORY_SEPARATOR . $swatchVisualFile
                        );

                        $newFile = $this->swatchHelper->moveImageFromTmp($swatchVisualFile);

                        if (substr($newFile, 0, 1) == '.') {
                            $newFile = substr($newFile, 1); // Fix generating swatch variations for files beginning with ".".
                        }

                    } else {
                        $newFile = $swatchVisualFile;
                    }
                    $this->swatchHelper->generateSwatchVariations($newFile);
                    $attributeOptionsData['swatchvisual']['value'][$index] = $newFile;
                }
            }

            // Add attribute options.
            foreach ($attributesOptionsData as $code => $datum) {
                /* @var \Magento\Catalog\Model\ResourceModel\Eav\Attribute $attribute */
                $attribute = $this->attributeRepository->get($code);
                $attribute->addData($datum);
                $attribute->save();

            }
        } catch (\Exception $ex) {
            throw new \Exception(__($ex->getMessage()), 0, $ex);
        }
    }

    /**
     * @return array|string[]
     */
    public function getAliases()
    {
        return [];
    }
}
