<?php
namespace Mtc\Finder\Setup\Patch\Data;

use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Catalog\Model\Product\Attribute\Backend\Price;

/**
 *  Product Attributes Patch
 */
class Attributes implements DataPatchInterface
{
    const ITEM_ID = "item_id";
    const RANGE_ID = "range_id";
    const TARTAN_ID = "tartan_id";
    const CLAN_ID = "clan_id";
    const MANU_REF = "manu_ref";
    const PROD_CODE = "product_code";
    const SUPPLIER_ID = "supplier_id";
    const MADE_AS = "made_as";
    const UNIT = "unit";
    const RETAIL_PRICE = "retail_price";
    const FABRIC = "fabric";
    const COMPOSITION = "composition";
    const CAPTION = "caption";
    const FRIENDLYNAME = "friendly_name";
    const COLOUR = "colour";

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * Attributes constructor.
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * @return array|string[]
     */
    public static function getDependencies()
    {
        return [];
    }

    public function apply()
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        if (!$eavSetup->getAttribute(Product::ENTITY, self::ITEM_ID)) {
            $eavSetup->addAttribute(Product::ENTITY, self::ITEM_ID, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Item Id',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '970',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::RANGE_ID)) {
            $eavSetup->addAttribute(Product::ENTITY, self::RANGE_ID, [
                'group' => 'General',
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Range Id',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '980',
                'apply_to' => ''
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::TARTAN_ID)) {
            $eavSetup->addAttribute(Product::ENTITY, self::TARTAN_ID, [
                'group' => 'General',
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Tartan Id',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '990',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::CLAN_ID)) {
            $eavSetup->addAttribute(Product::ENTITY, self::CLAN_ID, [
                'group' => 'General',
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Clan Id',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1000',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }


        if (!$eavSetup->getAttribute(Product::ENTITY, self::MANU_REF)) {
            $eavSetup->addAttribute(Product::ENTITY, self::MANU_REF, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Manu Ref',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1100',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }


        if (!$eavSetup->getAttribute(Product::ENTITY, self::PROD_CODE)) {
            $eavSetup->addAttribute(Product::ENTITY, self::PROD_CODE, [
                'group' => 'General',
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Product Code',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1200',
                'apply_to' => 'configurable'
            ]);
        }


        if (!$eavSetup->getAttribute(Product::ENTITY, self::SUPPLIER_ID)) {
            $eavSetup->addAttribute(Product::ENTITY, self::SUPPLIER_ID, [
                'group' => 'General',
                'type' => 'int',
                'backend' => '',
                'frontend' => '',
                'label' => 'Supplier Id',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1300',
                'apply_to' => 'configurable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::MADE_AS)) {
            $eavSetup->addAttribute(Product::ENTITY, self::MADE_AS, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Made As',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1400',
                'apply_to' => 'configurable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::FRIENDLYNAME)) {
            $eavSetup->addAttribute(Product::ENTITY, self::FRIENDLYNAME, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Friendly Name',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1450',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }


        if (!$eavSetup->getAttribute(Product::ENTITY, self::UNIT)) {
            $eavSetup->addAttribute(Product::ENTITY, self::UNIT, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Unit',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1500',
                'apply_to' => 'configurable'
            ]);
        }

        if (!$eavSetup->getAttribute(Product::ENTITY, self::RETAIL_PRICE)) {
            $eavSetup->addAttribute(Product::ENTITY, self::RETAIL_PRICE, [
                'group' => 'General',
                'type' => 'decimal',
                'backend' => Price::class,
                'frontend' => '',
                'label' => 'Retail Price',
                'input' => 'price',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1600',
                'apply_to' => 'simple,virtual,downloadable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::FABRIC)) {
            $eavSetup->addAttribute(Product::ENTITY, self::FABRIC, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Fabric',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1700',
                'apply_to' => 'configurable'
            ]);
        }

        if (!$eavSetup->getAttribute(Product::ENTITY, self::COMPOSITION)) {
            $eavSetup->addAttribute(Product::ENTITY, self::COMPOSITION, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Composition',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1800',
                'apply_to' => 'configurable'
            ]);
        }



        if (!$eavSetup->getAttribute(Product::ENTITY, self::CAPTION)) {
            $eavSetup->addAttribute(Product::ENTITY, self::CAPTION, [
                'group' => 'General',
                'type' => 'varchar',
                'backend' => '',
                'frontend' => '',
                'label' => 'Caption',
                'input' => 'text',
                'class' => '',
                'source' => '',
                'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                'visible' => true,
                'required' => false,
                'user_defined' => false,
                'default' => '',
                'searchable' => false,
                'filterable' => false,
                'comparable' => false,
                'visible_on_front' => false,
                'used_in_product_listing' => true,
                'unique' => false,
                'sort_order' => '1900',
                'apply_to' => 'configurable'
            ]);
        }


        if (!$eavSetup->getAttribute(Product::ENTITY, self::COLOUR)) {
            $eavSetup->addAttribute(
                \Magento\Catalog\Model\Product::ENTITY, 'colour', [
                    'group' => 'General',
                    'type' => 'int',
                    'backend' => '',
                    'frontend' => '',
                    'label' => 'Colour',
                    'input' => 'swatch_text',
                    'note' => '',
                    'class' => '',
                    'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                    'visible' => true,
                    'required' => false,
                    'user_defined' => true,
                    'default' => '0',
                    'searchable' => false,
                    'filterable' => false,
                    'comparable' => false,
                    'visible_on_front' => true,
                    'used_in_product_listing' => true,
                    'unique' => false,
                    'option' => [
                        'values' => ['Ancient','Modern','Weathered','Muted','Antique','Std','Design','Heirloom','Reproduction'],
                    ]
                ]
            );
        }
    }

    /**
     * @return array|string[]
     */
    public function getAliases()
    {
        return [];
    }
}
