<?php
namespace Mtc\InteractiveWeaver\ViewModel;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Data\Form\FormKey;
use Magento\Framework\UrlInterface;

class InteractiveWeaver implements ArgumentInterface
{

    /**
     * @var FormKey
     */
    private $formKey;

    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @param FormKey $formKey
     * @param UrlInterface $urlBuilder
     */
    public function __construct(
        FormKey $formKey,
        UrlInterface $urlBuilder
    ) {
        $this->formKey = $formKey;
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @return string
     */
    public function getFormAction()
    {
        return $this->urlBuilder->getUrl('interactive/weaver/submit', ['_secure' => true]);
    }

    /**
     * @return string
     * @throws LocalizedException
     */
    public function getFormKey()
    {
        return $this->formKey->getFormKey();
    }
}
