define([
    "jquery",
    "prototype",
    "jquery/ui",
    'Magento_Ui/js/modal/alert',
    'Mtc_InteractiveWeaver/js/jquery.ui.touch-punch',
    "domReady!"
], function ($, prototype, alert) {
    'use strict';
    $.Tartan = function()
    {
        this.KC_value = '';
    };

    $.Tartan.prototype = {

        init: function(tileImg, shadowImg) {
            this.colorsList = [];
            this.tile = tileImg;
            this.shadow = shadowImg;
            this.t = {
                DEFAULT_PALLET: {LB:"#0b76b4", NB:"#04162c", AB:"#426a89",
                    SB:"#202e6b", MB:"#475964", ICMB:"#13273f",
                    MR:"#8c0000", AR:"#b54532", MMR:"#7b1e24",
                    WR:"#8d4135", P:"#f80052", DP:"#ffc0cb",
                    AG:"#3e6f5e", MG:"#063829", MMG:"#4a6144",
                    WG:"#606c60", AYICA:"#e8c000", MY:"#f6b707",
                    MMY:"#bc890f", WY:"#9e935a", B:"#5a0821",
                    LBB:"#74254c", MP:"#571d53", AP:"#6e2446",
                    M:"#e0b0ff", MBICB:"#35211a", WB:"#5c503b",
                    ICAB:"#4d1f00", W:"#ffffff", I:"#fffff0",
                    G:"#808080", LG:"#D3D3D3", DG:"#28292a", BB:"#000000"},
                DEFAULT_TAB: "O10NB2R4NB8R72NB44W8Y4",
                tab: null,
                pType: "P",
                pallet: null,
            };
            this.defaultColors = {
                DEFAULT_PALLET: {LB:"#0b76b4", NB:"#04162c", AB:"#426a89",
                    SB:"#202e6b", MB:"#475964", ICMB:"#13273f",
                    MR:"#8c0000", AR:"#b54532", MMR:"#7b1e24",
                    WR:"#8d4135", P:"#f80052", DP:"#ffc0cb",
                    AG:"#3e6f5e", MG:"#063829", MMG:"#4a6144",
                    WG:"#606c60", AYICA:"#e8c000", MY:"#f6b707",
                    MMY:"#bc890f", WY:"#9e935a", B:"#5a0821",
                    LBB:"#74254c", MP:"#571d53", AP:"#6e2446",
                    M:"#e0b0ff", MBICB:"#35211a", WB:"#5c503b",
                    ICAB:"#4d1f00", W:"#ffffff", I:"#fffff0",
                    G:"#808080", LG:"#D3D3D3", DG:"#28292a", BB:"#000000"},
                DEFAULT_TAB: "O10NB2R4NB8R72NB44W8Y4",
                tab: null,
                pType: "P",
                pallet: null,
            };
            this.colorNames = {
                LB:"Light Blue", NB:"Navy Blue", AB:"Ancient Blue",
                SB:"Standard Blue", MB:"Muted Blue", ICMB:"IC Modern Blue",
                MR:"Modern Red", AR:"Ancient Red", MMR:"Muted Red",
                WR:"Weathered Red", P:"Pink", DP:"Dusk Pink",
                AG:"Ancient Green", MG:"Modern Green", MMG:"Muted Green",
                WG:"Weathered Green", AYICA:"Ancient Yellow & IC Ancient", MY:"Modern Yellow",
                MMY:"Muted Yellow", WY:"Weathered Yellow", B:"Burgundy",
                LBB:"Light Burgundy", MP:"Modern Purple", AP:"Ancient Purple",
                M:"Mauve", MBICB:"Modern Brown & IC Brown", WB:"Weathered Brown",
                ICAB:"IC Ancient Brown", W:"White", I:"Ivory",
                G:"Grey", LG:"Light Grey", DG:"Dark Grey", BB:"Black"
            }
            this.t.zoomFactor = 2;

            return this;
        },
        addColor: function(elem, color) {
            if ($(elem).hasClass('selected')) {
                $(elem).removeClass('selected');
                for(let i = this.colorsList.length - 1; i >= 0; i--) {
                    if(this.colorsList[i] === color) {
                        this.colorsList.splice(i, 1);
                    }
                }
            } else {
                $(elem).addClass('selected');
                if ($.inArray(color, this.colorsList) === -1) {
                    this.colorsList.push(color);
                }
            }
        },
        selectColor: function(elem) {
            $('#color-pallate').show();
            $(elem).hide();
            $('#add-selected').show();
            $('#add-selected').addClass("add-selected");
            $('#cancel').show();
        },
        cancel: function(elem) {
            $(elem).hide();
            $('#add-selected').hide();
            $('#color-pallate').hide();
            $('#add-color').show();
            $('#add-selected').removeClass("add-selected");
        },
        addSelectedColors: function(elem) {
            let newColorList = [];
            let i;
            let t;
            for(i=0; i < this.colorsList.length; i++){
                if(newColorList.indexOf(this.colorsList[i]) === -1) {
                    newColorList.push(this.colorsList[i]);
                }
            }
            if (newColorList.length < 2 || newColorList.length > 8) {
                alert({
                    title: 'Alert!',
                    content: 'Please add at least two colours to create a pattern or up to 8 before proceeding.',
                    actions: {
                        always: function(){}
                    }
                });
            } else {
                $('.center-content').hide();
                $('#color-pallate').hide();
                $('#add-selected').hide();
                $('#add-color').show();
                $('#cancel').hide();
                $('.info').show();
                $('.additional-info').show();
                let content = '';
                let threads = [];
                if ($('#color-list').find('input').length > 0) {
                    $('#color-list input').each(function (index) {
                        let eachcount = [];
                        let code = $(this).attr('name');
                        let value = $(this).val();
                        if (code && value) {
                            code = code.replace('thread-','');
                            eachcount['code'] = code
                            eachcount['value'] = value;
                            threads[index] = eachcount;
                        }
                    });
                }
                for(t=0; t < threads.length; t++) {
                    let data = threads[t];
                    if (this.colorsList.indexOf(data['code']) === -1) {
                        threads.splice(t, 1);
                    }
                }
                for(i=0;  i < this.colorsList.length; i++) {
                    let threadcount = '';
                    if(typeof threads[i] === 'undefined') {
                        threadcount = 10;
                    }
                     else {
                         threadcount = threads[i]['value'];
                     }
                    content += '<li data-z="'+ this.colorsList[i] +'">' +
                        '<div class="right"><div class="color-list-area" style="background-color: '+ this.defaultColors.DEFAULT_PALLET[this.colorsList[i]]+';"></div>' +
                        '<span>'+this.colorNames[this.colorsList[i]]+'</span></div>'+
                        '<div class="center">'+
                        '<span>Thread</span>' +
                        '<input type="number" name="thread-'+this.colorsList[i]+'" value="'+threadcount+'"/>' +
                        '<button class="btn btn-primary btn-lg" data-dir="up"><i class="fa fa-arrow-up"></i></button>' +
                        '<button class="btn btn-danger btn-lg" data-dir="down" ><i class="fa fa-arrow-down"></i></button>'+
                        '<span class="three-icon"></span><button class="btn btn-wrap-add btn-lg" data-dir="add" data-color="'+ this.colorsList[i] +'">+</button>'+
                        '</div>' +
                        '<div class="left">'+
                        '<button class="btn btn-wrap-cancel btn-lg" data-dir="remove"><span class="delete"></span></button>'+
                        '</div>' +
                        '</li>';
                }
                if (content !== '') {
                    $('#color-list').html(content).show();
                    this.drawTartan();
                    this.updatePattern();
                } else {
                    $('.center-content').show();
                }
            }
        },
        updatePattern: function() {
            let pattern = '';
            if ($('#color-list').find('input').length > 0) {
                $('#color-list input').each(function () {
                    let code = $(this).attr('name');
                    let value = $(this).val();
                    if (code && value) {
                        code = code.replace('thread-','');
                        pattern += code+value;
                    }
                });
                if (pattern) {
                    $('#design-submission-form').find('input[name="pattern"]').val(pattern);
                    $('#design-submission-form').find('input[name="pattern"]').show();
                }
            } else {
                $('#design-submission-form').find('input[name="pattern"]').val('');
                $('#design-submission-form').find('input[name="pattern"]').show();
            }
        },
        drawTartan: function() {
            const listItems = $("#color-list li");
            let colorCode = '';
            let threadCount = '';
            let inputSelector = '';
            let tabulation = '';
            listItems.each(function(idx, li) {
                colorCode = $(li).attr('data-z');
                inputSelector = 'input[name=thread-'+colorCode+']';
                threadCount = $(li).find(inputSelector).val();
                tabulation += colorCode+threadCount;
            });
            if (tabulation !== '') {
                $('#tartan-pattern').hide();
                let canvas = '';
                let tartanSetup = this;
                canvas = '<canvas id="tartanPatch" width="957.2812" height="368.4" tabulation="'+tabulation+'"\n' +
                    '                pallet="R=D40000;K=101010;DR=880000;NB=003C64;DG=003820;BG=0098A0;N=A0A0A0;DN=5C5C5C;LG=288028;G=006818;Y=E8C000;B=1474B4;LB=98C8E8;DP=440044;P=780078;LP=9C68A4;W=E0E0E0;T=8B4513;DT=#752020;DW=#ECD9C6;LT=D2B48C;"\n' +
                    '                pType="P">'
                $('#color-content-preview').html(canvas);
                this.tDocument = document.getElementById("tartanPatch");
                this.tContext = this.tDocument.getContext("2d");
                this.tilesAreLoaded = false;
                this.setup(this.tDocument.getAttribute("tabulation"),
                    this.tDocument.getAttribute("pallet"),
                    this.tDocument.getAttribute("pType"));
                const c = $('#tartanPatch');
                const container = $(c).parent();
                $(window).resize( respondCanvas );
                const Pallet = "R=D40000;K=101010;DR=880000;NB=003C64;DG=003820;BG=0098A0;N=A0A0A0;DN=5C5C5C;LG=288028;G=006818;Y=E8C000;B=1474B4;LB=98C8E8;DP=440044;P=780078;LP=9C68A4;W=E0E0E0;T=8B4513;DT=#752020;DW=#ECD9C6;LT=D2B48C;";
                function respondCanvas(){
                    c.attr('width', $(container).width() );
                    c.attr('height', $(container).height());
                    tartanSetup.setup(tabulation,Pallet,"P");
                }
                respondCanvas();
                let tartanNumber = Math.floor(Math.random()*90000) + 10000;
                $('#tartan-number').html('Tartan #: D'+tartanNumber);
            }

        },
        updateColors: function() {
            let selector = '#color-list';
            let inputSelector = "input[name*='thread']";
            let currentVal;
            $(selector).sortable({
                disabled:false,
                update: function() {
                    $('#color-list').sortable('toArray', {attribute: 'data-z'});
                }
            });
            const elist = this;
            $(selector).on('keyup', inputSelector, function(e) {
                if ($(this).val().length >= 3) {
                    $(this).val($(this).val().substr(0, 2));
                }
                if (!($.isNumeric($(this).val()))) {
                    $(this).val('');
                }
                if ($(this).val().length <= 2 && $.isNumeric($(this).val()) && $(this).val() >= 2 && $(this).val() <= 98) {
                    elist.drawTartan();
                    elist.updatePattern();
                } else {
                    $(this).val('');
                }
            });
            $(selector).sortable({
                disabled:false,
                update: function() {
                    $('#color-list').sortable('toArray', {attribute: 'data-z'});
                    elist.drawTartan();
                    elist.updatePattern();
                }
            });
            $(selector).on('click', '[data-z]', function(e) {
                let dir;
                const jTarget = $(e.target),
                    jItem = $(e.currentTarget),
                    jItems = $('#color-list li'),
                    index = jItems.index(jItem);
                dir = jTarget.data('dir');
                if (dir === undefined) {
                    dir = $(e.target).parent().data('dir');
                }
                switch (dir) {
                    case 'up':
                        currentVal = parseInt($(this).find("input[type=number]").val());
                        if (!isNaN(currentVal) && currentVal < 98 && currentVal >= 2) {
                            $(this).find("input[type=number]").val(currentVal + 2);
                            elist.drawTartan();
                            elist.updatePattern();
                        }
                        break;
                    case 'down':
                        currentVal = parseInt($(this).find("input[type=number]").val());
                        if (!isNaN(currentVal) && currentVal <= 98 && currentVal > 2) {
                            $(this).find("input[type=number]").val(currentVal - 2);
                            elist.drawTartan();
                            elist.updatePattern();
                        }
                        break;
                    case 'remove':
                        jItem.remove();
                        let colorItem = 'a[data-color='+jItem.attr('data-z');
                        $(colorItem).removeClass('selected');
                        elist.colorsList.splice(elist.colorsList.indexOf(jItem.attr('data-z')), 1);
                        elist.drawTartan();
                        elist.updatePattern();
                        break;
                    case 'add':
                        elist.colorsList.push(jTarget.data('color'));
                        let newColorContent;
                        newColorContent = '<li data-z="'+ jTarget.data('color') +'">' +
                            '<div class="right"><div class="color-list-area" style="background-color: '+ elist.defaultColors.DEFAULT_PALLET[jTarget.data('color')]+';"></div>' +
                            '<span>'+elist.colorNames[jTarget.data('color')]+'</span>\
                            </div>'+
                            '<div class="center">\
                            <span>Thread</span>' +
                            '<input type="number" name="thread-'+jTarget.data('color')+'" value="10"/>' +
                            '<button class="btn btn-primary btn-lg" data-dir="up"><i class="fa fa-arrow-up"></i></button>' +
                            '<button class="btn btn-danger btn-lg" data-dir="down" ><i class="fa fa-arrow-down"></i></button>\
                            <span class="three-icon"></span>\
                            <button class="btn btn-wrap-add btn-lg" data-dir="add" data-color="'+ jTarget.data('color') +'">\
                            +</button>\
                            </div>' +
                            '<div class="left">\
                            <button class="btn btn-wrap-cancel btn-lg" data-dir="remove"><span class="delete"></span></button></div>' +
                            '</li>';
                        $('#color-list').append(newColorContent);
                        elist.drawTartan();
                        elist.updatePattern();
                        break;
                }
            });
        },
        setup: function(inputTab, inputPallet, inputPType) {
            this.tContext.clearRect ( 0 , 0 , this.tDocument.width, this.tDocument.height );
            if (inputPType === null)
            {
                this.t.pType = "P";
            }
            else
            {
                this.t.pType = inputPType;
            }
            if (inputPallet === null)
            {
                if (this.t.pallet == null)
                {
                    this.t.pallet = t.DEFAULT_PALLET;
                }
            }
            else
            {
                inputPallet = decodeURIComponent(inputPallet)
                this.t.pallet = this.buildPallet(inputPallet);
            }

            if (inputTab === null)
            {
                if (this.t.tab === null)
                {
                    this.t.tab = this.t.DEFAULT_TAB;
                }
            }
            else
            {
                this.t.tab = decodeURIComponent(inputTab)
            }
            this.buildThreadcount(this.t.tab)
            this.img = new Image();
            this.img.src = this.tile;
            this.img.crossOrigin = "anonymous";
            this.img2 = new Image();
            this.img2.src = this.shadow;
            this.img2.crossOrigin = "anonymous";
            self = this
            this.img2.addEventListener("load", function() {self.tileLoaded()}, false);
        },
        tileLoaded: function() {
            this.createWarp();
            this.createWeft();
        },
        buildPallet: function(inputPallet) {
            let s, i, returnPallet, pal;
            returnPallet = this.t.DEFAULT_PALLET
            const myArray = inputPallet.split(";");
            // Final item has ; so minus 1
            s = myArray.length-1;
            let code;
            let colour;
            for (i = 0; i < s; i++) {
                pal = myArray[i]
                if (pal !== "") {
                    if (/^[a-zA-Z0-9 =]+$/.test(pal)) {
                        code = this.getCode(pal)
                        if (this.isalpha(code.charCodeAt(0))) {
                            colour = this.getColour(pal)
                            returnPallet[code] = colour
                        }
                    }
                }
            }
            return returnPallet;
        },
        getReverse: function(arrTab) {
            // tab is, say, length 5. Each Tab contains one colour code and one number of treads
            // I want to create and return  tab(0),tab(1),tab(2),tab(3),tab(4),tab(3),tab(2),tab(1)
            // tab(5) is not repeated and tab(0) is not added to reverse

            const revArray = arrTab.slice(1, arrTab.length - 1);
            revArray.reverse();
            return arrTab.concat(revArray);
        },
        buildThreadcount: function(tab) {
            let tmpt;
            let tmpc;
            let c;
            let weft_offset = 0;
            let MarkerFound = false;
            let tabPart = [];
            this.t.warpStripe = [];
            this.t.weftStripe = [];
            let i = 0;
            this.t.threadCount = 0;

            // returns -1 if not found else zero based number of chars
            weft_offset = tab.indexOf(".");
            if (weft_offset !== -1){
                tabPart = tab.split(".");
                MarkerFound = true;
            }else {
                tabPart[0] = tab;
            }

            // make this into function ??
            // change tab to warpStripe and weftStripe
            // or t.stripe be changed into t.warpstripe and t.weftstripe
            while(i < tabPart[0].length)
            {
                tmpc = "";
                tmpt = "";
                if (this.isalnum(tabPart[0].charCodeAt(i)) !== true)
                {
                    if(tabPart[0].charAt(i) === '.') break;
                    i++;
                }

                if (this.isalpha(tabPart[0].charCodeAt(i)) )
                {
                    for(c = 0; c < 4 && this.isalpha(tabPart[0].charCodeAt(i));c++)
                    {
                        tmpc = tmpc.concat(tabPart[0].charAt(i++));
                    }
                }
                if (this.isnum(tabPart[0].charCodeAt(i) ))
                {
                    for(c = 0;c < 4 && this.isnum(tabPart[0].charCodeAt(i));c++)
                    {
                        tmpt = tmpt.concat(tabPart[0].charAt(i++));

                    }
                    this.t.threadCount = this.t.threadCount + (parseInt(tmpt)*this.t.zoomFactor)
                }
                // warp
                if (tmpc !== "" && tmpt !== "")
                {
                    this.t.warpStripe.push({ccode:tmpc, threads:parseInt(tmpt)});
                }

            }
            if(MarkerFound === true) {
                i = 0;
                while(i < tabPart[1].length)
                {
                    tmpc = "";
                    tmpt = "";
                    if (this.isalnum(tabPart[1].charCodeAt(i)) !== true)
                    {
                        if(tabPart[1].charAt(i) === '.') { // If . found at start just jump over
                            i++;
                        }

                    }

                    if (this.isalpha(tabPart[1].charCodeAt(i)) )
                    {
                        for(c = 0; c < 4 && this.isalpha(tabPart[1].charCodeAt(i));c++)
                        {
                            tmpc = tmpc.concat(tabPart[1].charAt(i++));
                        }
                    }
                    if (this.isnum(tabPart[1].charCodeAt(i) ))
                    {
                        for(c = 0;c < 4 && this.isnum(tabPart[1].charCodeAt(i));c++)
                        {
                            tmpt = tmpt.concat(tabPart[1].charAt(i++));

                        }
                        // no provision for recording threadcount of different weft
                        //t.threadCount = t.threadCount + (parseInt(tmpt)*t.zoomFactor)
                    }
                    // weft
                    if (tmpc !== "" && tmpt !== "")
                    {
                        this.t.weftStripe.push({ccode:tmpc, threads:parseInt(tmpt)});
                    }

                }
            } else {
                // duplicate warp if no Marker found
                this.t.weftStripe = this.t.warpStripe
            }
            // P means pivoting. R = Repeating
            // R type patterns do not require reversing procedure
            if (this.t.pType === "P")
            {
                // see explaination in getReverse()
                this.t.warpStripe = this.getReverse(this.t.warpStripe); // new func
                this.t.weftStripe = this.getReverse(this.t.weftStripe);
            }
        },
        createWarp: function() {

            const w = this.tDocument.width;
            const h = this.tDocument.height;

            let i;
            i = 0
            let xpos;
            xpos = 0;
            let s;
            s = this.t.warpStripe.length - 1;
            let rc;
            let rw;
            while (xpos < w)
            {

                rc = this.getColourByCode(this.t.warpStripe[i].ccode)
                rw = this.t.warpStripe[i].threads * this.t.zoomFactor;
                this.tContext.fillStyle=rc;
                this.tContext.fillRect(xpos, 0, rw, h);
                xpos += this.t.warpStripe[i].threads * this.t.zoomFactor;
                i++
                if (i > s) i = 0;
            }

        },
        createWeft: function() {

            let w;
            w = this.tDocument.width;
            let h;
            h = this.tDocument.height;

            let i = 0;
            // off-screen context
            const canvas = document.createElement("canvas");
            const twillContext = canvas.getContext("2d");
            canvas.width = w
            canvas.height = h

            // Create a pattern with this image, and set it to "repeat".
            // img = tile.png
            twillContext.fillStyle = twillContext.createPattern(this.img, 'repeat');
            twillContext.fillRect(0, 0, w, h);
            let s;
            s = this.t.weftStripe.length-1;
            let ypos;
            ypos = 0;
            let rc;
            let rh;
            while (ypos < h)
            {
                rc = this.getColourByCode(this.t.weftStripe[i].ccode)
                rh = this.t.weftStripe[i].threads * this.t.zoomFactor;
                rc = rc.substring(1,7)
                //this doesn't work
                //weftContext.setAttribute('crossOrigin', 'anonymous');
                // image.crossOrigin="anonymous";
                twillContext.crossOrigin="anonymous";
                const map = twillContext.getImageData(0, ypos, w, rh);
                const imdata = map.data;

                //var bigint = parseInt(rc, 16);
                const r = parseInt(rc.substring(0, 2), 16);
                const g = parseInt(rc.substring(2, 4), 16);
                const b = parseInt(rc.substring(4, 6), 16);
                let a = 0;

                for(var p = 0, len = imdata.length; p < len; p+=4) {

                    a = imdata[p+3];

                    imdata[p] = r;
                    imdata[p+1] = g;
                    imdata[p+2] = b;
                    imdata[p+3] = a;
                }
                twillContext.putImageData(map,0,ypos);

                ypos += this.t.weftStripe[i].threads * this.t.zoomFactor;
                i++
                if (i > s) i = 0;
            }


            // Create a pattern with this image, and set it to "repeat".
            // img2 = shaddow.png
            twillContext.fillStyle = twillContext.createPattern(this.img2, 'repeat');
            twillContext.fillRect(0, 0, w, h);
            // draw the twill pattern weft stripes over the warp
            this.tContext.drawImage(canvas, 0, 0);
        },
        getCode: function(mess) {
            let marray;
            marray = mess.split("=");
            return marray[0].toUpperCase();
        },
        getColour: function(mess) {
            let marray;
            marray = mess.split("=");
            return "#"+marray[1].substr(0, 6);
        },
        isnum: function(a) {
            return ( a > 47 && a < 58 );
        },
        isalnum: function(a) {
            return ( ( a > 47 && a < 58 ) ||( a > 64 && a < 90 ) || ( a > 96 && a < 122 ));
        },
        isalpha: function(a) {
            return (( a > 64 && a < 90 ) || ( a > 96 && a < 122 ));
        },
        setLine: function(imgData, i, l) {
            let b;
            for (b = 0; b < i; b += 4) {
                this.setPixel(imgData, b)
            }
        },
        setPixel: function(imgData, i, rValue, gValue, bValue, aValue) {
            imgData.data[i+0] = rValue;
            imgData.data[i+1] = gValue;
            imgData.data[i+2] = bValue;
            imgData.data[i+3] = aValue;
        },
        getColourByCode: function(colourCode) {
            let colour = "#666666";
            if (this.t.pallet[colourCode] != null)
            {
                colour = this.t.pallet[colourCode]
            }
            return colour;
        }
    }

    return new $.Tartan();
});
