<?php
    
    namespace Mtc\Livechat\ViewModel;

    use Magento\Customer\Model\Session;
    use Magento\Framework\App\Config\ScopeConfigInterface;
    use Magento\Framework\Serialize\Serializer\Json;
    use Magento\Framework\View\Element\Block\ArgumentInterface;
    use Magento\Store\Model\ScopeInterface;

    class VisitorVM implements ArgumentInterface
    {
    
    
        /**
         * @param \Magento\Customer\Model\Session $customerSession
         */
        public function __construct(
            Session $customerSession,
            Json $json
        ) {
            $this->_customerSession = $customerSession;
            $this->json = $json;
        }
    
        /**
         * @return array
         */
        public function getCustomerDetails()
        {
            $result = [];
        
            if (null !== ($email = $this->getCustomerEmail())) {
                $result['email'] =  $email;
            }
        
            if (null !== ($name = trim($this->getCustomerName())) && '' !== $name) {
                $result['name'] = $name;
            }
        
           return $this->json->serialize($result);
        }
    
        /**
         * @return string
         */
        public function getCustomerEmail()
        {
            return $this->_customerSession->getCustomer()->getEmail();
        }
    
        /**
         * @return string
         * @throws \Magento\Framework\Exception\LocalizedException
         */
        public function getCustomerName()
        {
            return $this->_customerSession->getCustomer()->getName();
        }
        
    }
