<?php
namespace Mtc\Livechat\Controller\Adminhtml\GetProps;

use Magento\Backend\App\Action;
use \Mtc\LiveChat\Helper\Data;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Cache\ManagerFactory;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Controller\Result\JsonFactory;

class Index extends Action
{
    protected $resultPageFactory;
    protected $configWriter;
    
    private $cacheManagerFactory;
    
    /**
     * @param \Magento\Backend\App\Action\Context                   $context
     * @param \LiveChat\LiveChat\Helper\Data                        $dataHelper
     * @param \Magento\Framework\Controller\Result\JsonFactory      $resultJsonFactory
     * @param \Magento\Framework\App\Config\Storage\WriterInterface $configWriter
     * @param \Magento\Framework\App\Cache\ManagerFactory           $cacheManagerFactory
     */
    public function __construct(
        Context $context,
        Data $dataHelper,
        JsonFactory $resultJsonFactory,
        WriterInterface $configWriter,
        ManagerFactory $cacheManagerFactory
    ) {
        parent::__construct($context);
        $this->dataHelper = $dataHelper;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->configWriter = $configWriter;
        $this->cacheManagerFactory = $cacheManagerFactory;
    }
    
    /**
     * @return void
     */
    private function clearCache()
    {
        $cacheManager = $this->cacheManagerFactory->create();
        $types = $cacheManager->getAvailableTypes();
        $cacheManager->clean($types);
    }
    
    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $license_settings = array();
        
        $license_settings['license_email'] = $this->dataHelper->getLicenseEmail();
        $license_settings['cart_products'] = $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_CART_PRODUCTS);
        $license_settings['total_cart_value'] =
                $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_TOTAL_CART_VALUE);
        $license_settings['total_orders_count'] =
                $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_TOTAL_ORDERS_COUNT);
        $license_settings['last_order_details'] =
                $this->dataHelper->showCustomParam(Data::LC_CP_SHOW_LAST_ORDER_DETAILS);
        
        $result = $this->resultJsonFactory->create();

        return $result->setData(['license_settings' => json_encode($license_settings)]);
    }
}
