<?php

    namespace Mtc\Login\Plugin;

    use Magento\Backend\Model\Auth;
    use Magento\User\Model\User;
    use Magento\User\Model\UserFactory;
    use Mtc\Login\Service\LoginService;
    use Mtc\Login\Validators\ValidateMtcLogin;

class CheckMtc
{
    public function __construct(
        UserFactory $userFactory,
        ValidateMtcLogin $validateMtcLogin,
        LoginService $loginService
    ) {
        $this->_userFactory = $userFactory;
        $this->loginService = $loginService;
        $this->_userValidation = $validateMtcLogin;
    }

    /**
     * @param User $subject
     * @param callable $proceed
     * @param string $username
     * @param string $password
     * @return bool
     */
    public function beforeLogin(Auth $subject, $username, $password): array
    {

        if ($validMtcUser = $this->loginService->isValidUser($username, $password)) {
            $this->_userValidation->handle($validMtcUser);
                return [$username, $password];
        }
        return [$username, $password];
    }



}
