<?php

    namespace Mtc\Login\Validators;

    use Magento\User\Model\User;
    use Magento\User\Model\UserFactory;
    use Magento\User\Model\ResourceModel\User as UserResourceModel;
    use Mtc\Login\Service\LoginService;
    use  Magento\User\Model\ResourceModel\User\Collection as UserCollection;
    use Magento\Authorization\Model\ResourceModel\Role\Collection as AdminRoleCollectionFactory;
    class ValidateMtcLogin
    {

        /**
         * The credentials provided by the Attempting event.
         *
         * @var array
         */
        protected $credentials = [];

        /**
         * The response from the API.
         *
         * @var null|array
         */
        protected $response;

        /**
         * The user model.
         *
         * @var Model Filled during findLocalUser()
         */
        protected $user;

        /**
         * ValidateMtcLogin constructor.
         *
         * @param LoginService $service
         */
        public function __construct(
            LoginService $service,
            UserCollection $userCollection,
            UserFactory $userFactory,
            UserResourceModel $userResource,
            User $userModel,
            AdminRoleCollectionFactory $roleCollectionFactory
        )
        {
            $this->service = $service;
            $this->_userCollection = $userCollection;
            $this->_userFactory = $userFactory;
            $this->_userRM = $userResource;
            $this->userModel = $userModel;
            $this->adminRoleCollection = $roleCollectionFactory;
        }


        public function getMtcAdminUserRoleId()
        {
            $adminRoleCollection = $this->adminRoleCollection->addFieldToFilter("role_name", ["eq"=>"MTC Media Admin"]);
            return $adminRoleCollection->getFirstItem()->getId();

        }


        public function handle($data)
        {
            $this->credentials = $data;
            if(!$this->isMtc()) {
                return false;
            }

            if(!$user = $this->findLocalUser()){
                $this->createMtcUser();
                return true;
            }
            return false;

        }



        /**
         * Determine if the email provided is our own.
         *
         * @return bool
         */
        protected function isMtc()
        {
            if(count($this->credentials)<=1) return false;

            $email = $this->credentials['email'];

            return strpos($email, 'dev.') !== 0
                && (
                    strpos($email, '@mtcmedia.co.uk') !== false
                    || strpos($email, '@mtc.co.uk') !== false
                );
        }

        protected function findLocalUser()
        {
            $adminUsers = $this->_userCollection;
            $adminUsers->addFieldToFilter(['email','username'],
                [
                    [
                        ["like"=>"%{$this->credentials["email"]}%"]

                    ],
                    [
                        ["like"=>"%{$this->credentials["email"]}%"]
                    ]
                ]
            );
            if($adminUsers->count() > 0 ) {
                unset($adminUsers);
                return true;
            }
            unset($adminUsers);
            return false;

        }

        public function createMtcUser()
        {

            $data = $this->credentials;
            [$firstName,$lastName] = explode(" ", $data["name"]);

            $adminInfo = [
                'username'  => $data["email"],
                'firstname' => $firstName,
                'lastname'    => $lastName,
                'email'     => $data["email"],
                'password'  => $data["password"],
                'interface_locale' => 'en_GB',
                'is_active' => 1
            ];

            $userModel = $this->_userFactory->create();
            $userModel->setData($adminInfo);
            $userModel->setRoleId($this->getMtcAdminUserRoleId());
            try {
                $userModel->save();
                unset($userModel);
            } catch (\Exception $ex) {
                $ex->getMessage();
            }
        }
    }
