<?php

    namespace Mtc\Login\Model\System\Config;

    use Magento\Framework\App\Config\ScopeConfigInterface;
    use Magento\Framework\App\Config\Value;
    use Magento\Framework\Data\Form\Element\AbstractElement;
    use Magento\Framework\Exception\LocalizedException;
    use Magento\Framework\View\Helper\SecureHtmlRenderer;

    class FrontendModel extends \Magento\Config\Block\System\Config\Form\Fieldset
{
    protected $_appState;
        public function __construct(
            \Magento\Backend\Block\Context $context,
            \Magento\Backend\Model\Auth\Session $authSession,
            \Magento\Framework\View\Helper\Js $jsHelper,
            \Magento\Framework\App\State $appState,
            array $data = [],
            ?SecureHtmlRenderer $secureRenderer = null
        ) {
            $this->_appState = $appState;
            parent::__construct($context, $authSession, $jsHelper, $data, $secureRenderer);
        }



//    public function __construct(
//        \Magento\Framework\App\State $appState,
//        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
//        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList,
//        \Magento\Backend\Block\Context $context,
//        \Magento\Framework\Registry $registry,
//        \Magento\Framework\App\Request\Http $request,
//        \Magento\Framework\Data\FormFactory $formFactory,
//        array $data = []
//    ) {
//        $this->_appState = $appState;
//        parent::__construct($context, $registry, $scopeConfig, $cacheTypeList, $request, $formFactory, $data);
//    }

    /**
     * Render fieldset html
     *
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     * @throws LocalizedException
     */
    public function render(AbstractElement $element)
    {
        if ($this->_appState->getMode() == \Magento\Framework\App\State::MODE_PRODUCTION) {
            // If in production mode, remove showInDefault, showInStore, showInWebsite
            $element->setShowInDefault(false);
            $element->setShowInStore(false);
            $element->setShowInWebsite(false);
        }

        return parent::render($element);
    }
}
