<?php
namespace Mtc\Pinterest\Observer;

class CategoryInit implements \Magento\Framework\Event\ObserverInterface
{


    public $currentCategory;
    
    /**
     * Constructor.
     *
     * @param \Mtc\Pinterest\Service\CurrentCategory $currentCategory
     */
    public function __construct(
        \Mtc\Pinterest\Service\CurrentCategory $currentCategory
    ) {
        $this->currentCategory = $currentCategory;
    }
    
    /**
     * Execute method.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return \Mtc\Pinterest\Observer\CustomerInit
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $category   = $observer->getEvent()->getCategory();
        $categoryId = 0;
        
        if ($category) {
            $categoryId = $category->getId();
            
            $this->currentCategory->setCategoryId($categoryId);
            $this->currentCategory->setCategory($category);
        }
        
        return $this;
    }
}
