<?php
 
namespace Mtc\Pinterest\Observer;

class ProductInit implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Mtc\Pinterest\Service\CurrentProduct
     */
    public $currentProduct;
    
    /**
     * Constructor.
     *
     * @param \Mtc\Pinterest\Service\CurrentProduct $currentProduct
     */
    public function __construct(
        \Mtc\Pinterest\Service\CurrentProduct $currentProduct
    ) {
        $this->currentProduct = $currentProduct;
    }
    
    /**
     * Execute method.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return \Mtc\Pinterest\Observer\ProductInit
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $product   = $observer->getEvent()->getProduct();
        $productId = 0;
        
        if ($product) {
            $productId = $product->getId();
            
            $this->currentProduct->setProductId($productId);
            $this->currentProduct->setProduct($product);
        }
        
        return $this;
    }
}
