<?php

    namespace Mtc\Pinterest\ViewModel;

    use Magento\Framework\View\Element\Block\ArgumentInterface;

class CodeVM implements ArgumentInterface
{
    /**
     * @var \Mtc\Pinterest\Helper\Data
     */
    public $helper;

    public function __construct(
        \Mtc\Pinterest\Helper\Data $helper,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->helper = $helper;
        $this->_request = $request;
    }

    /**
     * Used in .phtml file and returns array of data.
     *
     * @return array
     */
    public function getPinterestPixelData()
    {
        $data = [];

        $data['id_data']               = $this->helper->getPinterestPixelId();
        $data['full_action_name']      = $this->_request->getFullActionName();
        $data['page_handles']          = $this->helper->getPageHandles();
        $data['page_handles_category'] = $this->helper->getPageHandles('category');
        $data['page_handles_product']  = $this->helper->getPageHandles('product');
        $data['page_handles_quote']    = $this->helper->getPageHandles('quote');
        $data['page_handles_order']    = $this->helper->getPageHandles('order');
        $data['page_handles_search']   = $this->helper->getPageHandles('search');

        return $data;
    }

    /**
     * Returns configuration value for Pinterest Pixel.
     *
     * @return bool
     */
    public function isPixelEnabled()
    {
        return $this->helper->isPixelEnabled();
    }

    /**
     * Returns configuration value for base_code_enabled.
     *
     * @return bool
     */
    public function isBaseCodeEnabled()
    {
        return $this->helper->isBaseCodeEnabled();
    }

    /**
     * Returns configuration value for noscript_enabled.
     *
     * @return bool
     */
    public function isNoScriptEnabled()
    {
        return $this->helper->isNoScriptEnabled();
    }

    /**
     * Returns configuration value for page with all.
     *
     * @return int
     */
    public function isPageWithAll()
    {
        return $this->helper->isPageWithAll();
    }

    /**
     * Returns category data needed for tracking.
     *
     * @return array
     */
    public function getCategoryData()
    {
        return $this->helper->getCategoryDataForJs();
    }

    /**
     * Returns product data needed for tracking.
     *
     * @param int $id
     * @return array
     */
    public function getProductData($id = 0)
    {
        return $this->helper->getProductData($id);
    }

    /**
     * Returns data needed for tracking from order object.
     *
     * @return array
     */
    public function getOrderData()
    {
        return $this->helper->getOrderData();
    }

    /**
     * Returns data needed for tracking from quote object.
     *
     * @return array
     */
    public function getQuoteData()
    {
        return $this->helper->getQuoteData();
    }

    /**
     * Returns search data needed for tracking.
     *
     * @return array
     */
    public function getSearchData()
    {
        return $this->helper->getSearchDataForJs();
    }

    /**
     * Returns configuration value for event.
     *
     * @param string $event
     * @return bool
     */
    public function isEventEnabled($event)
    {
        return $this->helper->isEventEnabled($event);
    }

    /**
     * Returns configuration value for detect_selected_sku
     *
     * @param string $productType
     * @param bool $server
     * @return bool
     */
    public function isDetectSelectedSkuEnabled($productType, $server = false)
    {
        return $this->helper->isDetectSelectedSkuEnabled($productType, $server);
    }

    /**
     * Returns price decimal sign
     *
     * @return string
     */
    public function getPriceDecimalSymbol()
    {
        return $this->helper->getPriceDecimalSymbol();
    }

    /**
     * Returns flag based on "Stores > Cofiguration > Sales > Tax
     * > Price Display Settings > Display Product Prices In Catalog"
     * Returns 0 or 1 instead of 1, 2, 3.
     *
     * @return int
     */
    public function getDisplayTaxFlag()
    {
        return $this->helper->getDisplayTaxFlag();
    }

    /**
     * Returns data for registration event.
     *
     * @param int $customerId
     * @return array
     */
    public function getDataForRegistrationEvent()
    {
        return $this->helper->getDataForRegistrationEvent();
    }

    /**
     * Returns configuration value for fp_cookie.
     *
     * @return boolean
     */
    public function isFpCookie()
    {
        return $this->helper->isFpCookie();
    }

    /**
     * Returns configuration value for md_frequency.
     *
     * @return boolean
     */
    public function isMdFrequency()
    {
        return $this->helper->isMdFrequency();
    }

    /**
     * Returns cookie_consent_enabled from config.
     *
     * @return int
     */
    public function isCookieConsentEnabled()
    {
        return $this->helper->isCookieConsentEnabled();
    }

    /**
     * Returns consent_cookie_name from config.
     *
     * @return string
     */
    public function getConsentCookieName()
    {
        return $this->helper->getConsentCookieName();
    }

    /**
     * Returns consent_cookie_key from config.
     *
     * @return string
     */
    public function getConsentCookieKey()
    {
        return $this->helper->getConsentCookieKey();
    }

    /**
     * Returns consent_cookie_value from config.
     *
     * @return string
     */
    public function getConsentCookieValue()
    {
        return $this->helper->getConsentCookieValue();
    }

    /**
     * Returns consent_button from config.
     *
     * @return string
     */
    public function getConsentButton()
    {
        return $this->helper->getConsentButton();
    }
}
