define([
    'jquery',
    'underscore',
    'ko',
    'Magento_Customer/js/section-config',
    'mage/storage',
    'jquery/jquery-storageapi'
], function ($, _, ko, sectionConfig, mageStorage) {
    'use strict';

    var DataCateg;
    return function (configuration) {

        // console.clear();
        DataCateg = configuration;
        var propagationStop = 0;

        $( document ).ajaxComplete(function( event, xhr, settings ) {
            // var times=0;
            // console.log(times++)
            var userData = {};
            var settingsUrl = settings.url;
            var sectionName = 'mtc_pinterest_pixel_matching_section';
            var urlPath = 'customer/section/load';




            if (propagationStop === 0
                && settingsUrl.indexOf(urlPath) !== -1
                && settingsUrl.indexOf(sectionName) !== -1
            ) {
                propagationStop = 1;
                var response = JSON.parse(xhr.responseText);

                var section;
                var sectionData;


                if (response !== 'undefined' && response.hasOwnProperty('mtc_pinterest_pixel_matching_section')) {

                    section = response.mtc_pinterest_pixel_matching_section;

                    if (section !== 'undefined' && section.hasOwnProperty('matching_data')) {
                        sectionData = section.matching_data;

                        if (!isEmpty(sectionData)) {
                            userData = sectionData;
                        }
                    }
                    if (configuration.baseCodeEnabled) {
                        
                        configuration.pixelCodes.forEach((pixelId) => {
                            if(!isEmpty(userData)) {
                                if (configuration.fpCookieStatus) {
                                    userData.fp_cookie = configuration.fpCookieStatus;
                                }
                                if (configuration.isMdFrequency) {
                                    userData.md_frequency = configuration.isMdFrequency;
                                }
                                window.pintrk('load', pixelId, userData);
                            } else {
                                window.pintrk('load', pixelId);
                            }
                        });

                       
                        
                        productConfig(configuration);
                        
                        if(configuration.isPageEnabled && configuration.isEventEnabled ) {
                            window.pintrk("track", "pagevisit",configuration.productData);
                        }
                        

                        // Add Pixel Events to the button's click handler
                        $('#product-addtocart-button').on('click', function() {
                            // Update product data if detection is enabled
                            if (configuration.isDetectSelectedSkuEnabled) {
                                updateProductData();
                            }
                            // The line_items must have at least one item
                            if (productData.line_items.length) {
                                if(configuration.isAddToCartEnabled)
                                {
                                    pintrk('track', 'addtocart', productData);
                                }

                            }
                        });
                        $('.action.towishlist').on('click', function() {
                            // Update product data if detection is enabled
                            if (configuration.isDetectSelectedSkuEnabled) {
                                updateProductData();
                            }
                            // The line_items must have at least one item
                            if (productData.line_items.length) {
                                if(configuration.isAddToWishListEnabled){pintrk('track', 'addtowishlist', productData);}
                            }
                        });
                        
                        
                        
                    }
                }
            }

        });

        var consentButton = $(configuration.consentButton);
        if (consentButton.length) {
            // Add consent grant call to the consent button's click handler
            consentButton.on('click', function () {
                setTimeout(function () {
                    checkConsent();
                }, 1000);
            });
        }
    }


    function updateProductData()
    {

        var productData = DataCateg.productData;
        var selectedPrice = 0;
        var selectedQty   = 0;
        var productId     = productData.productId;

        var $price        = $('#product-price-' + productId);
        var $priceInclTax = $('#price-including-tax-product-price-' + productId);

        
        if('line_items' in productData) {
            // Reset line_items
            productData.line_items = [];

            // Set value to 0
            productData.value = 0;

            var qty = 0;
            var newValue = 0;
            var itemValue = 0;
            var itemTotal = 0;

            for (let productId in lineItemsWithIds) {
                qty = lineItemsWithIds[productId].product_quantity;
                if (qty > 0) {
                    // Set the item in the line_items
                    productData.line_items.push(lineItemsWithIds[productId]);

                    // Increase value based on qty and price
                    itemValue = lineItemsWithIds[productId].product_price;
                    itemTotal = itemValue * qty;
                    // Make sure it is 2 decimal float
                    newValue += parseFloat(parseFloat(itemTotal).toFixed(2));
                }
            }

            // Set value to new value
            productData.value = newValue;
        }

        
    }
    
    
    function productConfig(configuration)
    {


        var lineItemsWithIds    =  configuration.lineItemsWithIdsJson;
        var selectors          = {};
        var nameAttributeValue = '';

        for (let productId in lineItemsWithIds) {
            // Set all quantities to zero to as default
            lineItemsWithIds[productId].product_quantity = 0;

            if (configuration.taxFlag) {
                if ($('#price-including-tax-product-price-' + productId).length) {
                    selectors['price' + productId] = $('#price-including-tax-product-price-' + productId);
                } else {
                    if ($('#product-price-' + productId).length) {
                        selectors['price' + productId] = $('#product-price-' + productId);
                    }
                }
            } else {
                if ($('#product-price-' + productId).length) {
                    selectors['price' + productId] = $('#product-price-' + productId);
                }
            }

            nameAttributeValue = 'super_group[' + productId + ']';
            selectors['qty' + productId] = $('input[name="' + nameAttributeValue + '"]');

            // Set all quantities and prices to current
            lineItemsWithIds[productId].product_quantity = selectors['qty' + productId].val();
            lineItemsWithIds[productId].product_price = formatPrice(selectors['price' + productId].text());

            // Set all selectors for change keyup paste click
            selectors['qty' + productId].on('change keyup paste click', function() {
                var nameAttr = $(this).attr('name');
                var productId = nameAttr.replace(/[^0-9]/g, '');

                // Make sure it is 2 decimal float
                // (Magento allows qty to be a float not just integer)
                lineItemsWithIds[productId].product_quantity = parseFloat(parseFloat($(this).val()).toFixed(2));
            });
        }

    }
    
    
    
    
    
    function isEmpty (obj){
        for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) {
                return false;
            }
        }
        return true;
    }
    function getCookieDataFromString(str) {
        var data = {};

        try {
            data = JSON.parse(str);
        } catch (e) {
            if (str.indexOf('=') > -1) {
                var arr = str.split('=');
                var key = '';
                var value = '';
                var k = 1;

                for (let i = 0; i < arr.length; i += 2) {
                    key = '';
                    value = '';

                    if (arr[i] !== undefined) {
                        key = arr[i].trim();
                    }

                    if (arr[k] !== undefined) {
                        value = arr[k].trim();
                    }

                    if (key) {
                        data[key] = value;
                    }

                    k += 2;
                }
            } else {
                data = str;
            }
        }

        return data;
    }
    function checkConsent() {
        var consentFlag = 0;
        if (isConsentGranted()==="allowed") {
            consentFlag = 1;
        }
        return consentFlag;
    }
    function isConsentGranted() {
        var isCookieConsentEnabled = DataCateg.isCookieConsentEnabled;

        // If cookie consent feature is disabled just allow everything.
        if (!isCookieConsentEnabled) {
            return 1;
        }

        var cookieName = DataCateg.cookieName;
        var cookie = $.mage.cookies.get(cookieName);
        var result = 0;


        if (!cookie) {
            return result;
        }

        var cookieData = getCookieDataFromString(cookie);
        var cookieKey = DataCateg.cookieKey;
        var cookieValue = DataCateg.cookieValue;

        if (cookieKey && cookieValue) {
            if (typeof cookieData === 'object' && cookieData[cookieKey] !== undefined) {
                var value = cookieData[cookieKey];

                if (value == cookieValue) {
                    result = 1;
                }
            }
        } else if (!cookieKey && cookieValue) {
            if (cookie == cookieValue) {
                result = 1;
            }
        } else if (cookieKey && !cookieValue) {
            if (typeof cookieData === 'object' && cookieKey in cookieData) {
                result = 1;
            }
        } else {
            if (cookie) {
                result = 1;
            }
        }

        
        return result;
    }
    // bof Utility functions used by all types of products
    function formatQty(text){
        // Make sure it is 2 decimal float
        return parseFloat(parseFloat(text).toFixed(2));
    }
    function formatPrice(text) {
        var decimalSymbol = escapeRegExp('<?= /* @noEscape */ $block->getPriceDecimalSymbol(); ?>');

        // RegEx to remove everything except numbers and decimal sign
        // Example: /[^0-9\.]/gi
        var regEx = new RegExp('[^0-9' + decimalSymbol + ']', 'gi');
        var priceText = text.replace(regEx, '');

        // Replace decimal sign with decimal point
        var price = priceText.replace(decimalSymbol, '.');

        // Make sure it is 2 decimal float
        return parseFloat(parseFloat(price).toFixed(2));
    }
    function escapeRegExp(text) {
        return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    }

});
