define([
    'jquery',
    'underscore',
    'ko',
    'Magento_Customer/js/section-config',
    'mage/storage',
    'jquery/jquery-storageapi'
], function ($, _, ko, sectionConfig, mageStorage) {
    'use strict';

    var DataCateg;
    return function (configuration) {

        // console.clear();
        DataCateg = configuration;
        var propagationStop = 0;

        $( document ).ajaxComplete(function( event, xhr, settings ) {
            // var times=0;
            // console.log(times++)
            var userData = {};
            var settingsUrl = settings.url;
            var sectionName = 'mtc_pinterest_pixel_matching_section';
            var urlPath = 'customer/section/load';




            if (propagationStop === 0
                && settingsUrl.indexOf(urlPath) !== -1
                && settingsUrl.indexOf(sectionName) !== -1
            ) {
                propagationStop = 1;
                var response = JSON.parse(xhr.responseText);

                var section;
                var sectionData;


                if (response !== 'undefined' && response.hasOwnProperty('mtc_pinterest_pixel_matching_section')) {

                    section = response.mtc_pinterest_pixel_matching_section;

                    if (section !== 'undefined' && section.hasOwnProperty('matching_data')) {
                        sectionData = section.matching_data;

                        if (!isEmpty(sectionData)) {
                            userData = sectionData;
                        }
                    }
                    if (configuration.baseCodeEnabled) {


                        configuration.pixelCodes.forEach((pixelId) => {
                            if(!isEmpty(userData)){
                                if (configuration.fpCookieStatus) {
                                    userData.fp_cookie = configuration.fpCookieStatus;
                                }
                                if (configuration.isMdFrequency) {
                                    userData.md_frequency = configuration.isMdFrequency;
                                }
                                window.pintrk('load', pixelId, userData);

                            } else {

                                window.pintrk('load', pixelId);

                            }
                        });

                        if(configuration.isPageEnabled && configuration.isEventEnabled ) {

                            window.pintrk("track", "pagevisit");
                        }

                        if(configuration.isOrderEventEnabled)
                        {
                            window.pintrk("track", configuration.orderEventName, configuration.orderEventData);
                        }

                    }
                }



            }

        });

        var consentButton = $(configuration.consentButton);
        if (consentButton.length) {
            // Add consent grant call to the consent button's click handler
            consentButton.on('click', function () {
                setTimeout(function () {
                    checkConsent();
                }, 1000);
            });
        }
    }
    function isEmpty (obj){
        for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) {
                return false;
            }
        }
        return true;
    }
    function getCookieDataFromString(str) {
        var data = {};

        try {
            data = JSON.parse(str);
        } catch (e) {
            if (str.indexOf('=') > -1) {
                var arr = str.split('=');
                var key = '';
                var value = '';
                var k = 1;

                for (let i = 0; i < arr.length; i += 2) {
                    key = '';
                    value = '';

                    if (arr[i] !== undefined) {
                        key = arr[i].trim();
                    }

                    if (arr[k] !== undefined) {
                        value = arr[k].trim();
                    }

                    if (key) {
                        data[key] = value;
                    }

                    k += 2;
                }
            } else {
                data = str;
            }
        }

        return data;
    }
    function checkConsent() {
        var consentFlag = 0;
        if (isConsentGranted()==="allowed") {
            consentFlag = 1;
        }
        return consentFlag;
    }
    function isConsentGranted() {
        var isCookieConsentEnabled = DataCateg.isCookieConsentEnabled;

        // If cookie consent feature is disabled just allow everything.
        if (!isCookieConsentEnabled) {
            return 1;
        }

        var cookieName = DataCateg.cookieName;
        var cookie = $.mage.cookies.get(cookieName);
        var result = 0;


        if (!cookie) {
            return result;
        }

        var cookieData = getCookieDataFromString(cookie);
        var cookieKey = DataCateg.cookieKey;
        var cookieValue = DataCateg.cookieValue;

        if (cookieKey && cookieValue) {
            if (typeof cookieData === 'object' && cookieData[cookieKey] !== undefined) {
                var value = cookieData[cookieKey];

                if (value == cookieValue) {
                    result = 1;
                }
            }
        } else if (!cookieKey && cookieValue) {
            if (cookie == cookieValue) {
                result = 1;
            }
        } else if (cookieKey && !cookieValue) {
            if (typeof cookieData === 'object' && cookieKey in cookieData) {
                result = 1;
            }
        } else {
            if (cookie) {
                result = 1;
            }
        }


        return result;
    }

});
