<?php
namespace Mtc\SvgImageUpload\Plugin\Magento\MediaStorage\Model\File\Validator\NotProtectedExtension;

use Magento\MediaStorage\Model\File\Validator\NotProtectedExtension;

class NotProtectedExtensionPlugin
{
    const IMAGE_EXTENSION = 'svg';

    /**
     * Remove vector images from protected extensions list
     *
     * @param NotProtectedExtension $subject
     * @param $result
     * @return mixed
     */
    public function afterGetProtectedFileExtensions(NotProtectedExtension $subject, $result)
    {
        $svgExtensions = [self::IMAGE_EXTENSION];
        foreach (array_keys($result) as $extension) {
            if (in_array($extension, $svgExtensions)) {
                unset($result[$extension]);
            }
        }
        return $result;
    }
}
