<?php

namespace Mtcmedia\Mailer;

/**
 * Swift Message subclass that can send itself
 * Created on 31.08.2016.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 */
class SwiftMessage extends \Swift_Message
{
    /**
     * The message will use this mailer to send itself
     * @var \Swift_Mailer
     */
    protected $mailer;

    /**
     * @param \Swift_Mailer $mailer
     */
    public function setMailer(\Swift_Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * Sets the 'to' header and adds a BCC to DEV_EMAIL if enabled
     * @param mixed $addresses
     * @param null $name
     * @return $this
     */
    public function setTo($addresses, $name = null)
    {
        if (is_array($addresses)) {
            $is_to_dev_email = isset($addresses[DEV_EMAIL]) || in_array(DEV_EMAIL, $addresses);
        } else {
            $is_to_dev_email = $addresses == DEV_EMAIL;
        }
        if (defined('MAIL_DEV_COPY') && MAIL_DEV_COPY && !$is_to_dev_email) {
            $this->setBcc(DEV_EMAIL);
        }
        return parent::setTo($addresses, $name);
    }

    /**
     * Sends (the message sends itself) using the $mailer
     * @return int
     * @throws \Exception
     */
    public function getSent()
    {
        if (!$this->mailer) {
            throw new \BadMethodCallException("Swift_Mailer not set");
        }

        return $this->mailer->send($this);
    }
}
