<?php

namespace Mtcmedia\Mailer;

use Illuminate\Container\Container;
use Illuminate\Support\ServiceProvider;

/**
 * MailerServiceProvider registers Mailer bindings
 * Created on 31.08.2016.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 */
class MailerServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(\Swift_Transport::class, function () {
            // if ?echo_mailer=1 is appened to URL, do send the emails, but echo them
            if (!empty($_REQUEST['echo_mailer'])) {
                return new EchoTransport();
            } else if (getenv('MAIL_DRIVER') === 'smtp') {
                // if smtp settings are defined in .env
                $transport = \Swift_SmtpTransport::newInstance(
                    getenv('MAIL_HOST'),
                    getenv('MAIL_PORT') ?: 25
                );

                if ($username = getenv('MAIL_USERNAME')) {
                    $transport->setUsername($username)
                        ->setPassword(getenv('MAIL_PASSWORD'));
                }

                return $transport;
            }
            // Sendmail by default
            return \Swift_SendmailTransport::newInstance('/usr/sbin/sendmail -bs');
        });

        // no binding for \Swift_Mailer, it's resolved by the container automagically

        $this->app->bind(SwiftMessage::class, function ($app) {
            $message = new \Mtcmedia\Mailer\SwiftMessage(null, null, 'text/html');
            $message
                ->setFrom([FROM_EMAIL => SITE_NAME])
            ;

            $message->setMailer($app->make(\Swift_Mailer::class));

            return $message;
        });
    }
}
