# Mailer wrapper / service provider for Core

## Installation
Add serviceprovider to header.inc.php:
```php 
<?php

(new \Mtcmedia\Mailer\MailerServiceProvider($app))->register();
```

## Usage: 

```php
<?php

use Illuminate\Support\Facades\App;
use Mtcmedia\Mailer\SwiftMessage;

$path = "./";
require_once $path . "core/includes/header.inc.php";

$message = App::make(SwiftMessage::class);
/* @var $message \Mtcmedia\Mailer\SwiftMessage */

$message->setTo(DEV_EMAIL);
$message->setSubject("Involveme.co.uk session PIN");
$message->setBody($email_body);

$message->getSent();
```

## Testing
When testing in browser, appending `?email_mailer=1` will register an EchoTransport as message transport which will
echo the email message instead of sending it.
