<?php

namespace Mtc\MembersBasket\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class UpdateDetailsRequest
 *
 * @package Mtc\Members\Http\Requests
 */
class MembersOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->order()->exists) {
            return MemberAuth::check()
                && (
                    MemberAuth::id() === $this->order()->member_id
                    || MemberAuth::user()->email === $this->order()->email
                );
        }

        return MemberAuth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    /**
     * Get member for request
     *
     * @return mixed|MemberModel
     */
    public function order()
    {
        if ($this->order instanceof OrderContract) {
            return $this->order;
        }

        return $this->order = App::make(OrderContract::class)::query()->findOrNew($this->order_id);
    }
}
