<?php

namespace Mtc\MembersBasket\Listeners;

use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\MemberAddress;

/**
 * Class PreFillUsersBasketDetails
 *
 * @package Mtc\Modules\Members
 */
class SetAddressBookForMember
{
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle($basket)
    {
        if (MemberAuth::check() && $basket->member_id == MemberAuth::id()) {
            $basket->address_book = MemberAuth::user()->addresses
                ->each(fn (MemberAddress $address) => $address->setHidden([
                    'member_id',
                    'created_at',
                    'updated_at',
                ]));
        }
    }
}
