<?php

use Illuminate\Routing\Router;
use Mtc\Members\Http\Middleware\LoggedInMember;
use Mtc\MembersBasket\Http\Controllers\OrderController;

$router->group([
    'prefix' => '/members/',
    'as' => 'members.',
    'middleware' => LoggedInMember::class,
], function (Router $router) {
    $router->get('orders', [OrderController::class, 'index'])->name('past-orders');
    $router->get('orders/{order_id}', [OrderController::class, 'show'])->name('view-order');

});
