<?php

namespace Mtc\MembersBasket\Providers;

use Illuminate\Auth\Events\Login;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\Basket\Events\BasketCreated;
use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Members\Events\LoadMembersAreaSections;
use Mtc\MembersBasket\Listeners\AddPastOrdersToMembersArea;
use Mtc\MembersBasket\Listeners\PreFillUsersBasketDetails;
use Mtc\MembersBasket\Listeners\SetUsersBasket;
use Mtc\MembersBasket\Listeners\UnsetUsersBasket;

/**
 * Class MemberProvider
 *
 * @package Mtc\Members\Providers
 */
class MembersBasketProvider extends EventServiceProvider
{
    /**
     * Event definitions
     *
     * @var array
     */
    protected $listen = [
        PaymentSuccessPage::class => [
            UnsetUsersBasket::class,
        ],
        Login::class => [
            SetUsersBasket::class,
        ],
        BasketCreated::class => [
            PreFillUsersBasketDetails::class
        ],
        LoadMembersAreaSections::class => [
            AddPastOrdersToMembersArea::class,
        ]
    ];

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/members.php', 'members');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'members_basket');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if (config('members.enabled') !== true) {
            return;
        }

        parent::boot();
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }
}
