<?php

namespace Mtc\MembersBasket\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\MembersBasket\Factories\BasketPreFillFactory;
use Mtc\Members\Member;

/**
 * Class PreFillUsersBasketDetails
 *
 * @package Mtc\Members
 */
class SetUsersBasket
{
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(Login $event)
    {
        // only customers
        if ($event->guard !== 'web-members') {
            return;
        }

        /** @var Member $member */
        $member = $event->user;
        $basket = App::make('basket');

        if ($basket->exists > 0) {
            $this->setMemberDataOnBasket($member);
        } elseif ($member->basket_id > 0) {
            $this->updateSessionWithUsersBasket($member->basket_id);
        }
    }

    /**
     * Assign members basket to session
     *
     * @param $basket_id\
     */
    protected function updateSessionWithUsersBasket($basket_id)
    {
        session()->put('basket_id', $basket_id);
    }

    /**
     * Attach member data to basket
     *
     * @param Member $member
     */
    protected function setMemberDataOnBasket(Member $member)
    {
        /** @var BasketRepositoryInterface $basket */
        $basket = App::make(BasketRepositoryInterface::class);

        if ($basket->hasItems()) {
            App::make(BasketPreFillFactory::class)->handle($member);
        }
    }
}
