<?php

namespace Mtc\MembersBasket\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class MemberProvider
 *
 * @package Mtc\Members\Providers
 */
class MembersBasketProvider extends EventServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/members.php', 'members');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'members_basket');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if (config('members.enabled') !== true) {
            return;
        }

        parent::boot();
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }

    /**
     * Get the events and handlers.
     *
     * @return array
     */
    public function listens()
    {
        return config('members.members_basket_events', []);
    }
}
