<?php

use Illuminate\Auth\Events\Login;
use Mtc\Basket\Events\BasketCreated;
use Mtc\Basket\Http\Resources\CheckoutAjax;
use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Members\Events\LoadMembersAreaSections;
use Mtc\MembersBasket\Listeners\AddPastOrdersToMembersArea;
use Mtc\MembersBasket\Listeners\PreFillUsersBasketDetails;
use Mtc\MembersBasket\Listeners\SetAddressBookForMember;
use Mtc\MembersBasket\Listeners\SetUsersBasket;
use Mtc\MembersBasket\Listeners\UnsetUsersBasket;

return [

    'members_basket_events' => [
        PaymentSuccessPage::class => [
            UnsetUsersBasket::class,
        ],
        Login::class => [
            SetUsersBasket::class,
        ],
        BasketCreated::class => [
            PreFillUsersBasketDetails::class
        ],
        LoadMembersAreaSections::class => [
            AddPastOrdersToMembersArea::class,
        ],
        CheckoutAjax::class => [
            SetAddressBookForMember::class,
        ]
    ],

    'basket_prefill_factory' => \Mtc\MembersBasket\Factories\BasketPreFillFactory::class,
];
