<?php

namespace Mtc\Members\Http\Controllers\Auth;

use Carbon\Carbon;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\Http\Requests\LoginRequest;
use Mtc\Members\Member;

/**
 * Class LoginController
 *
 * @package Mtc\Members
 */
class LoginController
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */


    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/members';

    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\LoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function login(LoginRequest $request)
    {
        $request->authenticate();

        $request->session()->regenerate();
        Session::put(Member::SESSION_KEY, $request->user('web-members')->id);

        return redirect()->intended($this->redirectTo);
    }

    /**
     * Show login form
     *
     * @param Request $request
     * @return string
     */
    public function showLoginForm(Request $request)
    {
        $this->page_meta['title'] = 'Login | ' . config('app.name');
        $this->page_meta['page_title'] = 'Login';
        return template('members/login.twig', [
            'page_meta' => $this->page_meta,
            'redirect' => $request->get('redirect'),
        ]);
    }


    /**
     * The user has logged out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function logout(Request $request)
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/members/login');
    }

}
