<?php

namespace Mtc\Members\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Mtc\Members\Member;

/**
 * Class RegisterController
 *
 * @package Mtc\Members
 */
class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */


    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/members';

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\Http\Response|string
     */
    public function showRegistrationForm(Request $request)
    {
        $this->page_meta['title'] = 'Register | ' . config('app.name');
        $this->page_meta['page_title'] = 'Register';
        return template('members/register.twig', [
            'page_meta' => $this->page_meta,
            'redirect' => $request->get('redirect'),
        ]);
    }

    public function register(Request $request)
    {
        Auth::guard('web-members');

        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:'.Member::class],
            'password' => ['required', 'confirmed', Password::defaults()],
        ]);

        $user = Member::query()
            ->create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
            ]);

        event(new Registered($user));

        Auth::login($user);

        if ($request->wantsJson()) {
            return [
                'success' => [
                    'redirect' => '/members',
                ]
            ];
        }
        return redirect('/members');
    }
}
