<?php

namespace Mtc\Members\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\MemberAddress;

/**
 * Class AdminMemberAddressRequest
 *
 * @package Mtc\Members\Http\Requests
 */
class AdminMemberAddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    /**
     * Get member for request
     *
     * @return mixed|MemberModel
     */
    public function member()
    {
        if ($this->member instanceof MemberModel) {
            return $this->member;
        }

        $member_model = App::make(MemberModel::class);
        if (is_numeric($this->member)) {
            $member_model = $member_model->find($this->member);
        }
        return $this->member = $member_model;
    }

    /**
     * Get member for request
     *
     * @return mixed|MemberModel
     */
    public function address()
    {
        if ($this->address instanceof MemberAddress) {
            return $this->address;
        }

        return $this->address = MemberAddress::query()->findOrNew($this->address);
    }
}
