<?php

namespace Mtc\Members;

use Illuminate\Database\Eloquent\Model;

/**
 * Class MemberTokens
 *
 * @package Mtc\Members
 */
class MemberTokens extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'member_tokens';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'member_id',
        'provider',
        'token',
        'data',
    ];

    /**
     * Cast variable to type
     *
     * @var array
     */
    protected $casts = [
        'data' => 'array'
    ];

    /**
     * Relationship to owner of this address
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class);
    }
}
