<?php

namespace Mtc\Members\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class StrongPassword
 *
 * @package Mtc\Members
 */
class StrongPassword implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return (mb_strlen($value) > 11 // at least 8 chars
            && preg_match('/[0-9]/', $value) // at least number
            && preg_match('/[a-z]/i', $value)// at least one letter
            && preg_replace('/[a-z0-9]/i', '', $value) !== ''
        );
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The password must be at least 12 characters and must contain letters, numbers and other characters.';
    }
}
