<?php

namespace Mtc\Members\Http\Controllers\Auth;

use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Mtc\Members\Member;

/**
 * Class LoginController
 *
 * @package Mtc\Members
 */
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */
    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/members';

    /**
     * Show login form
     *
     * @param Request $request
     * @return string
     */
    public function showLoginForm(Request $request)
    {
        $this->page_meta['title'] = 'Login | ' . config('app.name');
        $this->page_meta['page_title'] = 'Login';
        return template('members/login.twig', [
            'page_meta' => $this->page_meta,
            'redirect' => $request->get('redirect'),
        ]);
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard('web-members');
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        Session::put(Member::SESSION_KEY, $user->id);
    }

    /**
     * The user has logged out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    protected function loggedOut(Request $request)
    {
        Session::forget(Member::SESSION_KEY);
    }
}
