<?php

namespace Mtc\Members\Http\Requests;

use Illuminate\Support\Collection;
use Mtc\Foundation\Rules\ValidPhoneNumber;

/**
 * Class AdminSaveMemberRequest
 *
 * @package Mtc\Members\Http\Requests
 */
class SaveAdminMemberRequest extends AdminMemberRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $current_id = $this->member()->id;
        return collect([
            'email' => "required|email|unique:members,email,{$current_id}",
            'name' => 'required',
        ])
            ->when($this->filled('contact_no'), function (Collection $rules)  {
                return $rules->put('contact_no', [
                    new ValidPhoneNumber()
                ]);
            })
            ->toArray();
    }

}
