<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Enable/Disable functionality
    |--------------------------------------------------------------------------
    */
    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Password Strength
    |--------------------------------------------------------------------------
    |
    | Allows setting minimal password strength rule for validation
    | during sign-up and detail udpate
    |
    */
    'password_strength' => \Mtc\Members\Rules\MediumStrengthPassword::class,
//    'password_strength' => \Mtc\Members\Rules\StrongPassword::class,

    /*
    |--------------------------------------------------------------------------
    | Admin Filters
    |--------------------------------------------------------------------------
    |
    | Allows customising member search in admin area
    |
    */
    'admin_search_filters' => [
        \Mtc\Foundation\Filters\FilterById::class,
        \Mtc\Foundation\Filters\FilterByEmail::class,
        \Mtc\Members\Filters\FilterByName::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Roles
    |--------------------------------------------------------------------------
    |
    | Whether custom user roles are enabled on site
    |
    */
    'member_roles' => false,

    /*
    |--------------------------------------------------------------------------
    | Default user role
    |--------------------------------------------------------------------------
    |
    | This role will be set on user during normal registration process.
    | This role ensures default member functionality without any additional
    | access privileges.
    |
    */

    'default_role' => 'Customer',

    /*
    |--------------------------------------------------------------------------
    | Route configuration
    |--------------------------------------------------------------------------
    |
    | Allows Changing controllers for routes
    |
    */
    'auth_controllers' => [
        'register' => \Mtc\Members\Http\Controllers\Auth\RegisterController::class,
        'login' => \Mtc\Members\Http\Controllers\Auth\LoginController::class,
        'forgot_password' => \Mtc\Members\Http\Controllers\Auth\ForgotPasswordController::class,
        'reset_password' => \Mtc\Members\Http\Controllers\Auth\ResetPasswordController::class,
    ],

    'customer_controllers' => [
        'dashboard' => \Mtc\Members\Http\Controllers\DashboardController::class,
        'details' => \Mtc\Members\Http\Controllers\DetailController::class,
        'address' => \Mtc\Members\Http\Controllers\AddressController::class,
    ],

    'admin_controllers' => [
        'members' => \Mtc\Members\Http\Controllers\Admin\MemberController::class,
        'addresses' => \Mtc\Members\Http\Controllers\Admin\MemberAddressController::class,
        'roles' => \Mtc\Members\Http\Controllers\Admin\RoleController::class,
    ],

    'navigation_links_start' => [
        [
            'route' => route('members.dashboard'),
            'skip_dashboard' => true,
            'name' => 'Dashboard',
        ],
        [
            'route' => route('members.view-details'),
            'icon' => 'fas fa-user',
            'name' => 'Account Details',
            'button_name' => 'Edit Now',
        ],
        [
            'route' => route('members.addresses.index'),
            'icon' => 'fas fa-map-marker',
            'name' => 'Address Book',
            'button_name' => 'View Now',
        ],
    ],
    'navigation_links_end' => [
        [
            'route' => route('members.logout'),
            'icon' => 'fas fa-sign-out',
            'name' => 'Logout',
            'button_name' => 'Logout',
        ]
    ]
];
