<?php

namespace Mtc\Members\Providers;

use Mtc\Members\Http\Middleware\AddMemberDataToSite;
use Illuminate\Contracts\Http\Kernel;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\Members\Console\Commands\PopulateMembers;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\Listeners\MemberPopulateEntry;

/**
 * Class MemberProvider
 *
 * @package Mtc\Members\Providers
 */
class MemberProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/members.php', 'members');

        // Load a custom basket (or default).
        $this->app->singleton(MemberModel::class, function ($app) {
            return $this->app->make(Config::get('auth.providers.members.model'));
        });

        // Load a custom basket (or default).
        $this->app->singleton('member_auth', function ($app) {
            return $this->app->auth->guard('web-members');
        });

    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if (config('members.enabled') !== true) {
            return;
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');

        Event::listen('admin.populate', MemberPopulateEntry::class);

        if ($this->app->runningInConsole()) {
            $this->loadFactoriesFrom(dirname(__DIR__, 2) . '/database/factories');
            $this->commands([
                PopulateMembers::class
            ]);

            $this->publishes([
                dirname(__DIR__, 2) . '/resources/less' => resource_path('less/vendor'),
            ], 'assets');
        }

        $this->app->booted(function ($app) {
            $app[Kernel::class]->appendMiddlewareToGroup('web', AddMemberDataToSite::class);
        });
    }
}
