<?php

namespace Mtc\Members;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Mtc\Members\Events\LoadMembersAreaSections;

trait HasMembersNavigation
{
    public function sections()
    {
        return collect(config('members.navigation_links_start', []))
            ->merge(Event::dispatch(LoadMembersAreaSections::class))
            ->merge(collect(config('members.navigation_links_end')))
            ->filter()
            ->map(function ($section) {
                if (Route::has($section['route'])) {
                    $section['route'] = route($section['route']);
                }
                return $section;
            });
    }
}
