<?php

namespace Mtc\Members\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Redirect;
use Mtc\Foundation\Country;
use Mtc\Members\Contracts\MemberModel;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\Http\Requests\AdminMemberAddressRequest;
use Mtc\Members\Http\Requests\SaveAdminMemberAddressRequest;
use Mtc\Members\Member;
use Mtc\Members\MemberAddress;
use Mtc\Members\Role;

/**
 * Class MemberAddressController
 *
 * @package Mtc\Members\Http\Controllers\Admin
 */
class MemberAddressController extends Controller
{
    /**
     * Create a record
     *
     * @param AdminMemberAddressRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(AdminMemberAddressRequest $request)
    {
        $this->page_meta['title'] = 'Create Member Address Record for ' . $request->member()->name;
        return template('members/admin/edit_address.twig', [
            'page_meta' => $this->page_meta,
            'member' => $request->member(),
            'address' => $request->address(),
            'countries' => Country::query()->pluck('name', 'code'),
        ]);
    }

    /**
     * Store a new record
     *
     * @param SaveAdminMemberAddressRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(SaveAdminMemberAddressRequest $request)
    {
        $address = $request->member()->addresses()->create($request->input());
        if ($request->input('set_default')) {
            $request->member()->setDefaultAddress($address->id);
        }
        return Redirect::to(route('admin.members.edit', $request->member()))
            ->with('success', 'Address Saved');
    }

    /**
     * Edit a record
     *
     * @param AdminMemberAddressRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(AdminMemberAddressRequest $request)
    {
        $this->page_meta['title'] = 'Manage Member Address Record for ' . $request->member()->name;
        return template('members/admin/edit_address.twig', [
            'page_meta' => $this->page_meta,
            'countries' => Country::query()->pluck('name', 'code'),
            'member' => $request->member(),
            'address' => $request->address(),
        ]);
    }

    /**
     * Update existing record
     *
     * @param SaveAdminMemberAddressRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(SaveAdminMemberAddressRequest $request)
    {
        $request->address()->fill($request->input())->save();
        if ($request->input('set_default')) {
            $request->member()->setDefaultAddress($request->address()->id);
        }
        return Redirect::to(route('admin.members.edit', $request->member()))
            ->with('success', 'Address Updated');
    }

    /**
     * Remove record
     *
     * @param AdminMemberAddressRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(AdminMemberAddressRequest $request)
    {
        $request->address()->delete();
        return Redirect::back()->with('success', 'Member Address Removed');
    }

    /**
     * Set default address
     *
     * @param AdminMemberAddressRequest $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|void
     */
    public function setDefault(AdminMemberAddressRequest $request)
    {
        if ($request->address()->member_id !== $request->member()->id) {
            return abort(403);
        }

        $request->member()->default_address_id = $request->address()->id;
        $request->member()->save();

        return Redirect::back()->with('success', 'Default Address Updated');
    }
}
