<?php

namespace Mtc\Members\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Event;
use Mtc\Members\Events\LoadMembersAreaSections;
use Mtc\Members\HasMembersNavigation;

/**
 * Class DashboardController
 *
 * @package Mtc\Members\Http\Controllers
 */
class DashboardController extends Controller
{
    use HasMembersNavigation;

    /**
     * Render dashboard page
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $this->page_meta['title'] = 'My Account | ' . config('app.name');
        $this->page_meta['page_title'] = 'Members Section';
        return template('members/index.twig', [
            'page_meta' => $this->page_meta,
            'sections' => $this->sections(),
        ]);
    }
}
